/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_loan_approval sample from an ESB service.
 */
public class QuickstartESBBPELLoanApprovalTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_esb_bpel_loan_approval";

	public QuickstartESBBPELLoanApprovalTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartESBBPELLoanApprovalTestCase.class,
						TEST_NAME, "Quickstart_esb_bpel_loan_approval.esb,../Quickstart_bpel_loan_approval/Quickstart_bpel_loan_approval-1.jar,../Quickstart_bpel_loan_approval/Quickstart_bpel_loan_approval.war"));
	}

	public void testSendHello() throws Exception {
		String result=sendESBMessage("<request><firstName>Fred</firstName><name>Bloggs</name><amount>1000</amount></request>",
					"LoanApprovalBPELESB", "LoanApproval");
		
		if (result == null || result.contains("<accept>yes</accept>") == false) {
			fail("Invalid result");
		}
	}
}
