/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import junit.framework.Test;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;
import org.jboss.soa.bpel.tests.samples.purchase.CustomerInfo;
import org.jboss.soa.bpel.tests.samples.purchase.Invoice;
import org.jboss.soa.bpel.tests.samples.purchase.OrderFaultType;
import org.jboss.soa.bpel.tests.samples.purchase.PurchaseOrder;
import org.jboss.soa.bpel.tests.samples.purchase.PurchaseOrderPT;
import org.jboss.soa.bpel.tests.samples.purchase.PurchaseSVC;

/**
 * Test for common order purchasing scenarios.
 * 
 * @author Jeff DeLong
 * @author Alejandro Guizar
 */
public class TutorialBPELPurchaseTestCase extends RiftSawTest {

	private PurchaseOrderPT purchaseOrderPT;

	private static final String TEST_NAME = "Tutorial_bpel_purchase";

	public TutorialBPELPurchaseTestCase() {
		super(TEST_NAME);
	}

	public static Test suite() {
		return new RiftSawTestSetup(
				TutorialBPELPurchaseTestCase.class,
				TEST_NAME,
				"purchase-queue-service.xml,Tutorial_bpel_purchase.war,Tutorial_bpel_purchase_ejb.jar,Tutorial_bpel_purchase-1.jar");
	}

	protected void setUp() throws Exception {
		PurchaseSVC service = new PurchaseSVC();
		purchaseOrderPT = service.getPurchaseOrderSP();
	}

	public void testSendPurchaseOrderAvailable() {
		CustomerInfo customerInfo = new CustomerInfo();
		customerInfo.setCustomerId("manager");
		customerInfo.setAddress("123 Main St");

		PurchaseOrder purchaseOrder = new PurchaseOrder();
		purchaseOrder.setOrderId(10);
		purchaseOrder.setPartNumber(23);
		purchaseOrder.setQuantity(4);

		try {
			Invoice invoice =
					purchaseOrderPT.sendPurchaseOrder(customerInfo, purchaseOrder);
			// In our system, the part number is also the unit price!
			// The shipper charges a flat fare of $9.50
			assertEquals(purchaseOrder.getPartNumber() * purchaseOrder.getQuantity()
					+ 9.50, invoice.getAmount(), 0);
			assertEquals(purchaseOrder.getOrderId(), invoice.getOrderId());
		}
		catch (OrderFaultType e) {
			fail("shipping to available address should complete");
		}
	}

	public void testSendPurchaseOrderNotAvailable() {
		CustomerInfo customerInfo = new CustomerInfo();
		customerInfo.setCustomerId("freddy");
		customerInfo.setAddress("666 Elm St");

		PurchaseOrder purchaseOrder = new PurchaseOrder();
		purchaseOrder.setOrderId(20);
		purchaseOrder.setPartNumber(13);
		purchaseOrder.setQuantity(7);

		try {
			purchaseOrderPT.sendPurchaseOrder(customerInfo, purchaseOrder);
			fail("shipping to unavailable address should not complete");
		}
		catch (OrderFaultType e) {
			assertTrue(e.getFaultInfo()
					.getDetail()
					.indexOf(customerInfo.getAddress()) != -1);
		}
	}
}
