package org.jboss.soa.bpel.tests.samples.atm;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

/**
 * bank functions available to ATMs
 */
@WebService(name = "FrontEnd", targetNamespace = "http://jbpm.org/examples/atm")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface FrontEnd {

	/**
	 * initiate bank connection
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/connect")
	@WebResult(name = "ticketNo", partName = "ticketNo")
	public int connect();

	/**
	 * terminate bank connection
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/disconnect")
	@Oneway
	public void disconnect(
			@WebParam(name = "ticketNo", partName = "ticketNo") int ticketNo);

	/**
	 * retrieve bank connection status
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/status")
	@WebResult(name = "status", partName = "status")
	public String status(
			@WebParam(name = "ticketNo", partName = "ticketNo") int ticketNo);

	/**
	 * initiate customer access
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/logOn")
	public void logOn(
			@WebParam(name = "ticketNo", partName = "ticketNo") int ticketNo,
			@WebParam(name = "customerName", partName = "customerName") String customerName)
			throws UnauthorizedAccess_Exception;

	/**
	 * terminate customer access
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/logOff")
	@Oneway
	public void logOff(
			@WebParam(name = "customerName", partName = "customerName") String customerName);

	/**
	 * retrieve account balance
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/getBalance")
	@WebResult(name = "balance", partName = "balance")
	public double getBalance(
			@WebParam(name = "customerName", partName = "customerName") String customerName);

	/**
	 * increase account balance
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/deposit")
	@WebResult(name = "balance", partName = "balance")
	public double deposit(
			@WebParam(name = "customerName", partName = "customerName") String customerName,
			@WebParam(name = "amount", partName = "amount") double amount);

	/**
	 * decrease account balance
	 */
	@WebMethod(action = "http://jbpm.org/examples/atm/withdraw")
	@WebResult(name = "balance", partName = "balance")
	public double withdraw(
			@WebParam(name = "customerName", partName = "customerName") String customerName,
			@WebParam(name = "amount", partName = "amount") double amount)
			throws InsufficientFunds_Exception;

}
