package org.jboss.soa.bpel.tests.samples.travel;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

/**
 * This class was generated by the JAX-WS RI. JAX-WS RI 2.1.6 Generated source
 * version: 2.1
 */
@WebServiceClient(name = TravelService.SERVICE_NAME, targetNamespace = TravelService.TARGET_NAMESPACE, wsdlLocation = TravelService.WSDL_LOCATION)
public class TravelService extends Service {

	private static final String TRAVEL_AGENT_PORT_NAME = "TravelAgentPort";
	static final String SERVICE_NAME = "TravelService";
	static final String TARGET_NAMESPACE = "http://jbpm.org/examples/trip";
	static final String WSDL_LOCATION =
			"http://127.0.0.1:8080/Tutorial_bpel_travel_agency_travelAgent?wsdl";

	private final static URL WSDL_URL = createURL(WSDL_LOCATION);

	private static URL createURL(String location) {
		try {
			return new URL(location);
		}
		catch (MalformedURLException e) {
			throw new IllegalArgumentException(location, e);
		}
	}

	public TravelService(URL wsdlLocation, QName serviceName) {
		super(wsdlLocation, serviceName);
	}

	public TravelService() {
		super(WSDL_URL, new QName(TARGET_NAMESPACE, SERVICE_NAME));
	}

	/**
	 * @return returns TravelAgent
	 */
	@WebEndpoint(name = TRAVEL_AGENT_PORT_NAME)
	public TravelAgent getTravelAgentPort() {
		return super.getPort(new QName(TARGET_NAMESPACE, TRAVEL_AGENT_PORT_NAME),
				TravelAgent.class);
	}

	/**
	 * @param features A list of {@link javax.xml.ws.WebServiceFeature} to
	 * configure on the proxy. Supported features not in the <code>features</code>
	 * parameter will have their default values.
	 * @return returns TravelAgent
	 */
	@WebEndpoint(name = TRAVEL_AGENT_PORT_NAME)
	public TravelAgent getTravelAgentPort(WebServiceFeature... features) {
		return super.getPort(new QName(TARGET_NAMESPACE, TRAVEL_AGENT_PORT_NAME),
				TravelAgent.class, features);
	}

}
