#!/bin/sh
#
# Run Riftsaw Integration tests.

MAVEN_OPTS="-Xms512M -Xmx1024M"

RIFTSAW_PARENT_DIR="/Users/jeffyu/deploy/riftsaw"
DOWNLOAD_DIR="$RIFTSAW_PARENT_DIR/downloads"

JBOSS_VERSION="5.1.0.GA"
RIFTSAW_VERSION="2.1.4.Final"
AS_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jboss-$JBOSS_VERSION"
AS_CONFIG="default"
REPLACE_QA_JDBC="true"
JBOSS_ESB_VERSION="4.9"
JBOSS_ESB_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jbossesb-$JBOSS_ESB_VERSION"
DATABASE="db2"

STARTUP_TIME="3"

WS_STACK="native"
WS_VERSION="3.2.2.GA"
WS_STACK_DIR="$RIFTSAW_PARENT_DIR/downloads"

ANT_PROPERTIES="-Driftsaw.parent.dir=$RIFTSAW_PARENT_DIR -Ddatabase=$DATABASE -Dreplace.qa.jdbc=$REPLACE_QA_JDBC -Dorg.jboss.as.home=$AS_HOME -Dorg.jboss.as.config=$AS_CONFIG -Djbossesb.version=$JBOSS_ESB_VERSION -Dws.stack=$WS_STACK -Dws.version=$WS_VERSION -Dws.stack.dir=$WS_STACK_DIR -Dorg.jboss.esb.home=$JBOSS_ESB_HOME -Ddownload.dir=$DOWNLOAD_DIR -Dstartup.time=$STARTUP_TIME"
echo ANT_PROPERTIES=${ANT_PROPERTIES}

# build RiftSaw and running unit test
cd ..
mvn clean install -Pdocs 

# run integration test
cd qa
ant $ANT_PROPERTIES stop-server
ant $ANT_PROPERTIES clean
ant $ANT_PROPERTIES install.jbossesb

# clean up the database
ant $ANT_PROPERTIES drop.riftsaw.schema

# build the RiftSaw and run integration tests

cd ../integration-tests
mvn $ANT_PROPERTIES clean install 

# clean up the database
cd ../qa
ant $ANT_PROPERTIES drop.riftsaw.schema
