package org.jboss.soa.bpel.tests.performance;

import junit.framework.TestCase;

import org.jboss.soa.esb.qa.teargas.qs.QSRunner;

public class PerformanceTestCase extends TestCase {

	public PerformanceTestCase(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testRunTest() throws Exception {
		String resources = System.getenv("resources.dir");
		int count = 1;
		if (resources==null)
			resources = "src/test/resources/performance";
		try
		{
			count = Integer.parseInt(System.getProperty("count"));
		}
		catch(Exception ex)
		{
			fail("No message count specified. Please run the build with \"-Dcount=<number>\"");
		}
		
		String[] args = new String[3];
		args[0] = "-message="+resources+"/messages/hello_request1.xml";
		args[1] = "-address=http://localhost:8080/SimpleInvoke";
		args[2] = "-count="+count;
		
		QSRunner qs = new QSRunner();
		qs.parseArguments(args);
		if (!qs.validArguments()) {
			System.out.println("Usage: QSRunTest -address=<WS URL> -message=<message file> -count=<number of messages>");
			System.out.println("Additional properties for message sender can be specified using -D<property_name>=<value>");
		} else {
			System.out.println("Running performance test with "+count+" messages.");
			qs.runTest();
		}
	}
}
