/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import org.jboss.internal.soa.esb.services.security.SecurityContextPropagator;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.util.ClassUtil;

public final class SecurityContextPropagatorFactory {
    private SecurityContextPropagatorFactory() {
    }

    public static SecurityContextPropagator createFromConfig() throws SecurityServiceException {
        return SecurityContextPropagatorFactory.create(Configuration.getSecurityContextPropagatorImplementationClass());
    }

    public static SecurityContextPropagator create(String className) throws SecurityServiceException {
        if (className == null) {
            return null;
        }
        return SecurityContextPropagatorFactory.createInstance(className);
    }

    private static SecurityContextPropagator createInstance(String className) throws SecurityServiceException {
        try {
            Class propagator = ClassUtil.forName(className, SecurityContextPropagatorFactory.class);
            Object newInstance = propagator.newInstance();
            return (SecurityContextPropagator)newInstance;
        }
        catch (ClassNotFoundException e) {
            throw new SecurityServiceException("SecurityContextPropagator implementation '" + className + "' not found", e);
        }
        catch (InstantiationException e) {
            throw new SecurityServiceException("Instantiation Exception while trying to create a SecurityContextPropagator of type '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new SecurityServiceException("IllegalAccessException while trying to create a SecurityContextPropagator of type '" + className + "'", e);
        }
    }
}

