/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.io.PrintStream;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.Util;

public class SystemPrintln
extends AbstractActionPipelineProcessor {
    public static final String PRE_MESSAGE = "message";
    public static final String FULL_MESSAGE = "printfull";
    public static final String PRINT_STREAM = "outputstream";
    public static final String DEFAULT_PRE_MESSAGE = "Message structure";
    private MessagePayloadProxy payloadProxy;
    private String printlnMessage;
    private boolean printFullMessage;
    private boolean useOutputStream;

    public SystemPrintln(ConfigTree config) {
        this.printlnMessage = config.getAttribute(PRE_MESSAGE, DEFAULT_PRE_MESSAGE);
        this.printFullMessage = config.getAttribute(FULL_MESSAGE, "false").equalsIgnoreCase("true");
        this.useOutputStream = config.getAttribute(PRINT_STREAM, "true").equals("true");
        String primaryDataLocation = config.getAttribute("datalocation");
        if (primaryDataLocation != null) {
            config.setAttribute("get-payload-location", primaryDataLocation);
            this.payloadProxy = new MessagePayloadProxy(config);
        } else {
            this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
        }
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    public Message process(Message message) throws ActionProcessingException {
        Object messageObject = null;
        try {
            messageObject = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        PrintStream stream = this.useOutputStream ? System.out : System.err;
        stream.println(this.printlnMessage + ": ");
        String messageStr = null;
        if (this.printFullMessage && message != null) {
            messageStr = message.toString();
            stream.println("[ " + messageStr + " ]");
        } else if (messageObject instanceof byte[]) {
            messageStr = Util.format(new String((byte[])messageObject));
            stream.println("[" + messageStr + "].");
        } else {
            if (messageObject != null) {
                messageStr = Util.format(messageObject.toString());
                stream.println("[" + messageStr + "].");
            }
            for (int i = 0; i < message.getAttachment().getUnnamedCount(); ++i) {
                Object payload = message.getAttachment().itemAt(i);
                if (payload instanceof Message) {
                    Message attachedMessage = (Message)payload;
                    try {
                        payload = this.payloadProxy.getPayload(attachedMessage);
                    }
                    catch (MessageDeliverException e) {
                        throw new ActionProcessingException(e);
                    }
                }
                if (payload instanceof byte[]) {
                    stream.println("attachment " + i + ": [" + new String((byte[])payload) + "].");
                    continue;
                }
                stream.println("attachment " + i + ": [" + payload + "].");
            }
        }
        return message;
    }
}

