/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TestMessageStoreSink {
    private final ArrayList<String> list = new ArrayList();
    private final Lock lock = new ReentrantLock();
    private final Condition waitCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] waitForMessages(int numberOfMessages, long maxDelay) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + maxDelay;
        this.lock.lock();
        try {
            long now;
            long waitPeriod;
            while (this.list.size() != numberOfMessages && (waitPeriod = endTime - (now = System.currentTimeMillis())) > 0L) {
                try {
                    this.waitCondition.await(waitPeriod, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                }
            }
            String[] results = this.list.toArray(new String[0]);
            this.list.clear();
            int numResults = results.length;
            System.out.println("TestMessageStoreSink: Returning " + numResults + " message" + (numResults == 1 ? "" : "s"));
            for (int count = 0; count < numResults; ++count) {
                System.out.println("TestMessageStoreSink: Returning message[" + count + "]: " + results[count]);
            }
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(String message) {
        this.lock.lock();
        try {
            this.list.add(message);
            System.out.println("TestMessageStoreSink: Adding message: " + message);
            this.waitCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages() {
        this.lock.lock();
        try {
            this.list.clear();
            System.out.println("TestMessageStoreSink: Clearing messages");
        }
        finally {
            this.lock.unlock();
        }
    }
}

