/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.monitoring;

import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.actions.monitoring.MVELMonitorMBean;
import org.jboss.soa.esb.actions.monitoring.MonitoringPatternBean;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

public class MVELMonitor
implements MVELMonitorMBean {
    public ArrayList<MonitoringPatternBean> monitoredEvents = new ArrayList();
    private ConfigTree m_config;

    public MVELMonitor(ConfigTree config) {
        this.m_config = config;
    }

    public ArrayList getMonitoredEvents() {
        return this.monitoredEvents;
    }

    public void reset() {
        this.monitoredEvents = new ArrayList();
    }

    public void addEvent(Message message, MonitoringPatternBean mpb) {
        mpb.setMessageString(message.toString());
        this.monitoredEvents.add(mpb);
    }

    protected void registerMBean() throws InstanceAlreadyExistsException, InstanceNotFoundException, MBeanRegistrationException, MBeanRegistrationException, MalformedObjectNameException, NotCompliantMBeanException {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        ObjectName listObjectName = this.getObjectName();
        if (mbeanServer.isRegistered(listObjectName)) {
            mbeanServer.unregisterMBean(listObjectName);
        }
        mbeanServer.registerMBean(this, listObjectName);
    }

    protected ObjectName getObjectName() throws MalformedObjectNameException {
        ObjectName listObjectName = null;
        String deploymentName = this.m_config.getParent().getParent().getAttribute("deployment");
        String serviceName = this.m_config.getParent().getAttribute("service-name");
        StringBuffer objectName = new StringBuffer("category=MVELMonitor");
        if (deploymentName != null) {
            objectName.append(",").append("deployment").append("=").append(deploymentName);
        }
        if (serviceName != null) {
            if (objectName.length() > 0) {
                objectName.append(",");
            }
            objectName.append("service-name").append("=").append(serviceName);
        }
        listObjectName = new ObjectName("jboss.esb:" + objectName.toString());
        return listObjectName;
    }
}

