/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.routing.AbstractRouter;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.jms.DefaultJMSPropertiesSetter;
import org.jboss.soa.esb.notification.jms.JMSPropertiesSetter;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.JmsUtil;
import org.jboss.soa.esb.util.JndiUtil;
import org.jboss.soa.esb.util.Util;

public class JMSRouter
extends AbstractRouter {
    private static Logger logger = Logger.getLogger(JMSRouter.class);
    public static final String PERSISTENT_ATTR = "persistent";
    public static final String PRIORITY_ATTR = "priority";
    public static final String TIME_TO_LIVE_ATTR = "time-to-live";
    public static final String SECURITY_PRINCIPAL = "security-principal";
    public static final String SECURITY_CREDITIAL = "security-credential";
    public static final String PROPERTY_STRATEGY = "property-strategy";
    private ConfigTree properties;
    private String queueName;
    private final JMSPropertiesSetter jmsPropertiesStrategy;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private String jndiContextFactory;
    private String jndiUrl;
    private String jndiPkgPrefix;
    private String connectionFactory;
    private JmsConnectionPool pool;
    private Destination jmsDestination;
    private ThreadLocal<JmsSession> SESSION = new ThreadLocal();
    private String jmsReplyToName;
    private Properties environment;

    public JMSRouter(ConfigTree propertiesTree) throws ConfigurationException, NamingException, JMSException {
        super(propertiesTree);
        String ttlStr;
        this.properties = propertiesTree;
        this.queueName = this.properties.getAttribute("jndiName");
        if (this.queueName == null) {
            throw new ConfigurationException("JMSRouter must specify a 'jndiName' property.");
        }
        boolean persistent = Boolean.parseBoolean(this.properties.getAttribute(PERSISTENT_ATTR, "true"));
        this.deliveryMode = persistent ? 2 : 1;
        String priorityStr = this.properties.getAttribute(PRIORITY_ATTR);
        if (priorityStr != null) {
            this.priority = Integer.parseInt(priorityStr);
        }
        if ((ttlStr = this.properties.getAttribute(TIME_TO_LIVE_ATTR)) != null) {
            this.timeToLive = Long.parseLong(ttlStr);
        }
        this.jndiContextFactory = this.properties.getAttribute("jndi-context-factory", Configuration.getJndiServerContextFactory());
        this.jndiUrl = this.properties.getAttribute("jndi-URL", Configuration.getJndiServerURL());
        this.jndiPkgPrefix = this.properties.getAttribute("jndi-pkg-prefix", Configuration.getJndiServerPkgPrefix());
        this.connectionFactory = this.properties.getAttribute("connection-factory", "ConnectionFactory");
        String propertyStrategy = this.properties.getAttribute(PROPERTY_STRATEGY);
        if (propertyStrategy == null) {
            this.jmsPropertiesStrategy = new DefaultJMSPropertiesSetter();
        } else {
            try {
                Class propertyStrategyClass = ClassUtil.forName(propertyStrategy, this.getClass());
                this.jmsPropertiesStrategy = (JMSPropertiesSetter)propertyStrategyClass.newInstance();
            }
            catch (Throwable th) {
                throw new ConfigurationException("Failed to instantiate property strategy class: " + propertyStrategy, th);
            }
        }
        String securityPrincipal = this.properties.getAttribute(SECURITY_PRINCIPAL);
        String securityCredential = this.properties.getAttribute(SECURITY_CREDITIAL);
        boolean useJMSSecurity = JmsUtil.isSecurityConfigured(securityPrincipal, securityCredential);
        if (securityPrincipal != null && securityCredential == null) {
            throw new ConfigurationException("'security-principal' must be accompanied by a 'security-credential'");
        }
        if (securityCredential != null && securityPrincipal == null) {
            throw new ConfigurationException("'security-credential' must be accompanied by a 'security-principal'");
        }
        if (useJMSSecurity) {
            securityCredential = JmsUtil.getPasswordFromFile(securityCredential);
        }
        this.environment = JndiUtil.parseEnvironmentProperties(propertiesTree);
        this.environment.setProperty("java.naming.provider.url", this.jndiUrl);
        this.environment.setProperty("java.naming.factory.initial", this.jndiContextFactory);
        this.environment.setProperty("java.naming.factory.url.pkgs", this.jndiPkgPrefix);
        try {
            this.pool = useJMSSecurity ? JmsConnectionPoolContainer.getPool(this.environment, this.connectionFactory, securityPrincipal, securityCredential) : JmsConnectionPoolContainer.getPool(this.environment, this.connectionFactory);
        }
        catch (ConnectionException ce) {
            throw new ConfigurationException("Unexpected error obtaining JMS connection pool");
        }
        this.createQueueSetup(this.queueName, this.jndiContextFactory, this.jndiUrl, this.jndiPkgPrefix, this.connectionFactory, securityPrincipal, securityCredential);
    }

    public Message process(Message message) throws ActionProcessingException {
        this.route(message);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void route(Object message) throws ActionProcessingException {
        JmsSession jmsSession = this.getJmsSession();
        try {
            this.handleRouting(jmsSession, message);
        }
        catch (JMSException jmse) {
            try {
                if (jmsSession.getTransacted()) {
                    jmsSession.rollback();
                    throw new ActionProcessingException("Unexpected exception routing message", jmse);
                }
                JmsSession newJmsSession = this.getJmsSession();
                try {
                    this.handleRouting(newJmsSession, message);
                }
                finally {
                    this.pool.closeSession(newJmsSession);
                }
            }
            catch (JMSException jmse2) {
                throw new ActionProcessingException("Unexpected exception routing message", jmse);
            }
        }
        finally {
            this.pool.closeSession(jmsSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRouting(JmsSession jmsSession, Object message) throws JMSException, ActionProcessingException {
        this.SESSION.set(jmsSession);
        try {
            if (!(message instanceof Message)) {
                throw new ActionProcessingException("Cannot send Object [" + message.getClass().getName() + "] to destination [" + this.queueName + "]. Object must be an instance of org.jboss.soa.esb.message.Message) .");
            }
            Message esbMessage = (Message)message;
            try {
                javax.jms.Message jmsMessage = null;
                if (this.unwrap) {
                    Object objectFromBody = this.getPayloadProxy().getPayload(esbMessage);
                    jmsMessage = this.createJMSMessageWithObjectType(objectFromBody);
                } else {
                    jmsMessage = this.createObjectMessage(Util.serialize(esbMessage));
                }
                this.setStringProperties(jmsMessage);
                this.setJMSProperties(esbMessage, jmsMessage);
                this.setJMSReplyTo(jmsMessage, esbMessage);
                this.send(jmsMessage);
            }
            catch (JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                String errorMessage = "Exception while sending message [" + message + "] to destination [" + this.queueName + "].";
                logger.error((Object)errorMessage);
                throw new ActionProcessingException(errorMessage, e);
            }
        }
        finally {
            this.SESSION.set(null);
        }
    }

    private JmsSession getJmsSession() throws ActionProcessingException {
        try {
            return this.pool.getSession();
        }
        catch (ConnectionException ce) {
            throw new ActionProcessingException("Unexpected ConnectionException acquiring JMS session", ce);
        }
        catch (NamingException ne) {
            throw new ActionProcessingException("Unexpected NamingException acquiring JMS session", ne);
        }
        catch (JMSException jmse) {
            throw new ActionProcessingException("Unexpected JMSException acquiring JMS session", jmse);
        }
    }

    protected javax.jms.Message createJMSMessageWithObjectType(Object objectFromBody) throws JMSException {
        TextMessage jmsMessage = null;
        if (objectFromBody instanceof String) {
            jmsMessage = this.SESSION.get().createTextMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending Text message: [" + objectFromBody + "] to destination [" + this.queueName + "]."));
            }
            jmsMessage.setText((String)objectFromBody);
        } else if (objectFromBody instanceof byte[]) {
            jmsMessage = this.SESSION.get().createBytesMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending byte[] message: [" + objectFromBody + "] to destination [" + this.queueName + "]."));
            }
            ((BytesMessage)jmsMessage).writeBytes((byte[])objectFromBody);
        } else {
            jmsMessage = this.createObjectMessage(objectFromBody);
        }
        return jmsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(javax.jms.Message jmsMessage) throws JMSException {
        MessageProducer jmsProducer = this.SESSION.get().createProducer(this.jmsDestination);
        try {
            jmsProducer.setPriority(this.priority);
            jmsProducer.setDeliveryMode(this.deliveryMode);
            jmsProducer.setTimeToLive(this.timeToLive);
            if (this.jmsReplyToName != null) {
                Queue jmsReplyToDestination = this.SESSION.get().createQueue(this.jmsReplyToName);
                jmsMessage.setJMSReplyTo((Destination)jmsReplyToDestination);
            }
            jmsProducer.send(jmsMessage);
        }
        finally {
            jmsProducer.close();
        }
    }

    protected void setJMSProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        this.jmsPropertiesStrategy.setJMSProperties(fromESBMessage, toJMSMessage);
    }

    protected javax.jms.Message createObjectMessage(Object message) throws JMSException {
        ObjectMessage jmsMessage = this.SESSION.get().createObjectMessage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending Object message: [" + message + "] to destination [" + this.queueName + "]."));
        }
        jmsMessage.setObject((Serializable)message);
        return jmsMessage;
    }

    private void setStringProperties(javax.jms.Message msg) throws JMSException {
        String messagePropPrefix = "message-prop-";
        for (KeyValuePair property : this.properties.attributesAsList()) {
            String key = property.getKey();
            if (!key.startsWith(messagePropPrefix) || key.length() <= messagePropPrefix.length()) continue;
            msg.setStringProperty(key.substring(messagePropPrefix.length()), property.getValue());
        }
    }

    public Serializable getOkNotification(Message message) {
        return null;
    }

    public Serializable getErrorNotification(Message message) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createQueueSetup(String queueName, String jndiContextFactory, String jndiUrl, String jndiPkgPrefix, String connectionFactory, String securityPrincipal, String securityCredential) throws ConfigurationException {
        Properties environment = this.getEnvironment();
        try {
            JmsSession jmsSession = this.pool.getSession();
            try {
                Context oCtx = NamingContextPool.getNamingContext(environment);
                try {
                    try {
                        this.jmsDestination = (Queue)oCtx.lookup(queueName);
                    }
                    catch (NamingException ne) {
                        try {
                            oCtx = NamingContextPool.replaceNamingContext(oCtx, environment);
                            this.jmsDestination = (Queue)oCtx.lookup(queueName);
                        }
                        catch (NamingException nex) {
                            this.jmsDestination = jmsSession.createQueue(queueName);
                        }
                    }
                    MessageProducer jmsProducer = jmsSession.createProducer(this.jmsDestination);
                    jmsProducer.close();
                }
                finally {
                    NamingContextPool.releaseNamingContext(oCtx);
                }
            }
            finally {
                this.pool.closeSession(jmsSession);
            }
        }
        catch (Throwable t) {
            throw new ConfigurationException("Failed to configure JMS Queue for routing.", t);
        }
    }

    Properties getEnvironment() {
        return this.environment;
    }

    protected void createQueueSetup(String queueName) throws ConfigurationException {
        this.createQueueSetup(queueName, null, null, null, null, null, null);
    }

    protected void setJMSReplyTo(javax.jms.Message jmsMessage, Message esbMessage) throws URISyntaxException, JMSException, NamingException, ConnectionException, NamingContextException {
        EPR replyToEpr = esbMessage.getHeader().getCall().getReplyTo();
        if (!(replyToEpr instanceof JMSEpr)) {
            return;
        }
        JMSEpr jmsEpr = (JMSEpr)replyToEpr;
        String destinationType = jmsEpr.getDestinationType();
        if (destinationType.equals("queue")) {
            this.jmsReplyToName = jmsEpr.getDestinationName();
        }
    }

    public boolean isDeliveryModePersistent() {
        return this.deliveryMode == 2;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public String getContextFactoryName() {
        return this.jndiContextFactory;
    }

    public String getJndiURL() {
        return this.jndiUrl;
    }

    public String getJndiPkgPrefix() {
        return this.jndiPkgPrefix;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }
}

