/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers.ActionMapper;
import org.jboss.soa.esb.listeners.config.mappers.FsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.FtpListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.GroovyListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.JmsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers.NotificationMapper;
import org.jboss.soa.esb.listeners.config.mappers.ScheduleMapper;
import org.jboss.soa.esb.listeners.config.mappers.ScheduledListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.SqlListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.UntypedListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FtpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.GroovyListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JbrListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsJcaProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsProviderType;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.ScheduledListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.SqlBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.SqlListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.SqlProviderDocument;
import org.jboss.soa.esb.listeners.message.MessageAwareListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBAwareGenerator {
    private static final Logger logger = Logger.getLogger(ESBAwareGenerator.class);
    private XMLBeansModel model;

    public ESBAwareGenerator(XMLBeansModel model) {
        this.model = model;
    }

    public Document generate() throws ConfigurationException {
        Document doc = YADOMUtil.createDocument();
        doc.appendChild(doc.createComment("\n\tNOTE: DO NOT MODIFY\n\tThis file was auto-generated.\n"));
        Element root = YADOMUtil.addElement(doc, "jbossesb-listeners");
        root.setAttribute("parameterReloadSecs", this.model.getParameterReloadSecs());
        List<ServiceDocument.Service> services = this.model.getServices();
        for (int i = 0; i < services.size(); ++i) {
            ServiceDocument.Service service = services.get(i);
            if (!XMLBeansModel.exposesInVMListener(service)) continue;
            this.addInVMListener(root, service, i);
        }
        List<Listener> listeners = this.model.getESBAwareListeners();
        for (Listener listener : listeners) {
            this.addESBAwareConfig(root, listener);
        }
        return doc;
    }

    private void addInVMListener(Element root, ServiceDocument.Service service, int serviceIndex) throws ConfigurationException {
        Element listenerNode = YADOMUtil.addElement(root, "InVM-" + serviceIndex);
        Element properties = listenerNode.getOwnerDocument().createElement("properties");
        MapperUtil.mapListenerServiceAttributes(listenerNode, service, false);
        listenerNode.setAttribute("listenerClass", MessageAwareListener.class.getName());
        Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
        eprNode.setAttribute("protocol", "invm");
        MapperUtil.mapProperties(service.getPropertyList(), properties);
        eprNode.setAttribute("URL", "invm://" + InVMEpr.createEncodedServiceId(service.getCategory(), service.getName()) + "/" + YADOMUtil.getAttribute(properties, "inVMPassByValue", "false") + "?" + YADOMUtil.getAttribute(properties, "inVMLockStep", "false") + "#" + YADOMUtil.getAttribute(properties, "inVMLockStepTimeout", "10000"));
        listenerNode.setAttribute("maxThreads", YADOMUtil.getAttribute(properties, "maxThreads", "1"));
        listenerNode.setAttribute("transacted", Boolean.toString(this.getInVMTransacted(service)));
        YADOMUtil.removeEmptyAttributes(eprNode);
        ActionMapper.map(listenerNode, service, this.model);
    }

    private boolean getInVMTransacted(ServiceDocument.Service service) throws ConfigurationException {
        if (service.isSetInvmScope()) {
            return service.getInvmTransacted();
        }
        if (service.isSetListeners()) {
            for (Listener listener : service.getListeners().getListenerList()) {
                Provider provider;
                Bus bus;
                if (listener instanceof ScheduledListenerDocument.ScheduledListener) {
                    if (!((ScheduledListenerDocument.ScheduledListener)listener).getTransacted()) continue;
                    return true;
                }
                if (listener instanceof JmsListenerDocument.JmsListener) {
                    bus = this.model.getBus(listener.getBusidref());
                    if (!(bus instanceof JmsBusDocument.JmsBus)) continue;
                    provider = this.model.getProvider(bus);
                    if (provider instanceof JmsJcaProviderDocument.JmsJcaProvider) {
                        JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider = (JmsJcaProviderDocument.JmsJcaProvider)provider;
                        if (jmsJcaProvider.isSetTransacted() && !jmsJcaProvider.getTransacted()) continue;
                        return true;
                    }
                    if (!(provider instanceof JmsProviderType)) continue;
                    JmsMessageFilterDocument.JmsMessageFilter filter = ((JmsListenerDocument.JmsListener)listener).getJmsMessageFilter();
                    if (filter == null) {
                        filter = ((JmsBusDocument.JmsBus)bus).getJmsMessageFilter();
                    }
                    if (filter == null || !filter.getTransacted()) continue;
                    return true;
                }
                if (!(listener instanceof SqlListenerDocument.SqlListener) || !((bus = this.model.getBus(listener.getBusidref())) instanceof SqlBusDocument.SqlBus) || !((provider = this.model.getProvider(bus)) instanceof SqlProviderDocument.SqlProvider) || !((SqlProviderDocument.SqlProvider)provider).getTransacted()) continue;
                return true;
            }
        }
        return false;
    }

    private void addESBAwareConfig(Element root, Listener listener) throws ConfigurationException {
        Element listenerConfigTree;
        if (listener instanceof JmsListenerDocument.JmsListener) {
            listenerConfigTree = JmsListenerMapper.map(root, (JmsListenerDocument.JmsListener)listener, this.model);
        } else if (listener instanceof ScheduledListenerDocument.ScheduledListener) {
            listenerConfigTree = ScheduledListenerMapper.map(root, (ScheduledListenerDocument.ScheduledListener)listener, this.model);
        } else if (listener instanceof FsListenerDocument.FsListener) {
            listenerConfigTree = FsListenerMapper.map(root, (FsListenerDocument.FsListener)listener, this.model);
        } else if (listener instanceof FtpListenerDocument.FtpListener) {
            listenerConfigTree = FtpListenerMapper.map(root, (FtpListenerDocument.FtpListener)listener, this.model);
        } else if (listener instanceof SqlListenerDocument.SqlListener) {
            listenerConfigTree = SqlListenerMapper.map(root, (SqlListenerDocument.SqlListener)listener, this.model);
        } else {
            if (listener instanceof JbrListenerDocument.JbrListener) {
                logger.error((Object)"JbossRemoting listener only supported in Gateway mode.");
                return;
            }
            listenerConfigTree = listener instanceof GroovyListenerDocument.GroovyListener ? GroovyListenerMapper.map(root, (GroovyListenerDocument.GroovyListener)listener, this.model) : UntypedListenerMapper.map(root, listener, this.model);
        }
        if (listener instanceof AbstractScheduledListener) {
            ScheduleMapper.map(listenerConfigTree, (AbstractScheduledListener)listener, this.model);
        }
        ServiceDocument.Service listenerService = this.model.getService(listener);
        ActionMapper.map(listenerConfigTree, listenerService, this.model);
        NotificationMapper.map(listenerConfigTree, listenerService, this.model);
    }
}

