/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.publish.ContractInfo;
import org.jboss.internal.soa.esb.publish.ContractProvider;
import org.jboss.internal.soa.esb.publish.ContractProviderLifecycleResource;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.http.HttpServletSecUtil;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.listeners.config.mappers120.HttpGatewayMapper;
import org.jboss.soa.esb.listeners.gateway.http.HttpMessageComposer;
import org.jboss.soa.esb.listeners.gateway.http.HttpRequestWrapper;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.security.PublicCryptoUtil;
import org.jboss.soa.esb.util.ClassUtil;

public class HttpGatewayServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(HttpGatewayServlet.class);
    public static final String PAYLOAD_AS = "payloadAs";
    public static final String EXCEPTION_MAPPINGS = "httpExceptionMappings";
    public static final String ASYNC_SERVICE_INVOKE = "asyncServiceInvoke";
    public static final String ASYNC_STATUS_CODE = "asyncStatusCode";
    public static final String ASYNC_PAYLOAD = "asyncPayloadPath";
    public static final String ASYNC_PAYLOAD_CONTENT_TYPE = "asyncPayloadContentType";
    public static final String ASYNC_PAYLOAD_CHARACTER_ENCODING = "asyncPayloadCharacterEncoding";
    private Service service;
    private ServiceInvoker serviceInvoker;
    private ContractInfo contract = null;
    private boolean asyncInvoke;
    private int asyncStatusCode = 200;
    private byte[] asyncPayload;
    private String asyncContentType;
    private String asyncCharacterEncoding;
    private MessageComposer<HttpRequestWrapper> messageComposer;
    private long blockingTimeout = 30000L;
    private Map<String, Integer> exceptionMappings;

    public void init(ServletConfig config) throws ServletException {
        String serviceCategory = config.getInitParameter("target-service-category");
        String serviceName = config.getInitParameter("target-service-name");
        this.service = new Service(serviceCategory, serviceName);
        try {
            this.serviceInvoker = new ServiceInvoker(this.service);
        }
        catch (MessageDeliverException e) {
            throw new ServletException("Unable to create ServiceInvoker for Service '" + this.service + "'.", (Throwable)e);
        }
        try {
            ContractProvider contractProvider = ContractProviderLifecycleResource.getContractProvider(serviceCategory, serviceName);
            String endpointAddress = config.getInitParameter("endpointAddress");
            if (contractProvider != null) {
                this.contract = contractProvider.provideContract(endpointAddress);
            }
        }
        catch (LifecycleResourceException lre) {
            throw new ServletException((Throwable)lre);
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
        ConfigTree configTree = this.toConfigTree(config);
        try {
            this.messageComposer = MessageComposer.Factory.getInstance(configTree.getAttribute("composer-class", HttpMessageComposer.class.getName()), configTree);
        }
        catch (ConfigurationException e) {
            throw new ServletException("Failed to create message composer.", (Throwable)e);
        }
        catch (MessageDeliverException e) {
            throw new ServletException("Failed to create message composer.", (Throwable)e);
        }
        this.asyncInvoke = configTree.getBooleanAttribute(ASYNC_SERVICE_INVOKE, false);
        if (this.asyncInvoke) {
            String asyncSCConfig = configTree.getAttribute(ASYNC_STATUS_CODE);
            try {
                this.asyncStatusCode = Integer.parseInt(asyncSCConfig);
            }
            catch (NumberFormatException e) {
                throw new ServletException("Invalid static asynchronous response code configuration '" + asyncSCConfig + "'.", (Throwable)e);
            }
            String payloadPath = configTree.getAttribute(ASYNC_PAYLOAD);
            if (payloadPath != null) {
                try {
                    this.asyncPayload = this.readStaticAsyncResponse(payloadPath);
                }
                catch (ConfigurationException e) {
                    throw new ServletException("Invalid Exception to HTTP Status mapping configuration.", (Throwable)e);
                }
                this.asyncContentType = configTree.getAttribute(ASYNC_PAYLOAD_CONTENT_TYPE);
                this.asyncCharacterEncoding = configTree.getAttribute(ASYNC_PAYLOAD_CHARACTER_ENCODING);
            }
        } else {
            this.blockingTimeout = configTree.getLongAttribute("synchronousTimeout", 30000L);
        }
        String exceptionMappingsCSV = configTree.getAttribute(EXCEPTION_MAPPINGS);
        if (exceptionMappingsCSV != null) {
            try {
                this.exceptionMappings = HttpGatewayMapper.decodeExceptionMappingsCSV(exceptionMappingsCSV);
            }
            catch (ConfigurationException e) {
                throw new ServletException("Invalid Exception to HTTP Status mapping configuration.", (Throwable)e);
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Message outMessage;
        Message inMessage;
        if ("wsdl".equalsIgnoreCase(req.getQueryString())) {
            resp.setCharacterEncoding("UTF-8");
            String mimeType = this.contract != null ? this.contract.getMimeType() : "text/xml";
            resp.setContentType(mimeType);
            String data = this.contract != null ? this.contract.getData() : "<definitions/>";
            resp.setContentLength(data.length());
            BufferedWriter writer = new BufferedWriter(resp.getWriter());
            writer.write(data);
            ((Writer)writer).flush();
            return;
        }
        HttpRequestWrapper wrapper = new HttpRequestWrapper(req, resp, this.service);
        try {
            inMessage = this.messageComposer.compose(wrapper);
        }
        catch (MessageDeliverException e) {
            throw new ServletException("Failed to create message.", (Throwable)e);
        }
        if (!PublicCryptoUtil.INSTANCE.isAuthRequestOnMessage(inMessage)) {
            HttpServletSecUtil.addAuthDetailsToMessage(req, inMessage);
        }
        try {
            if (this.asyncInvoke) {
                this.serviceInvoker.deliverAsync(inMessage);
                resp.setStatus(this.asyncStatusCode);
                resp.setHeader(ASYNC_SERVICE_INVOKE, "true");
                if (this.asyncPayload != null) {
                    resp.setContentLength(this.asyncPayload.length);
                    resp.setContentType(this.asyncContentType);
                    if (this.asyncCharacterEncoding != null) {
                        resp.setCharacterEncoding(this.asyncCharacterEncoding);
                    }
                    resp.getOutputStream().write(this.asyncPayload);
                } else {
                    resp.setContentLength(0);
                }
                return;
            }
            outMessage = this.serviceInvoker.deliverSync(inMessage, this.blockingTimeout);
            resp.setHeader(ASYNC_SERVICE_INVOKE, "false");
        }
        catch (MessageDeliverException e) {
            throw new ServletException("Failed to deliver message.", (Throwable)e);
        }
        catch (RegistryException e) {
            throw new ServletException("Failed to deliver message.", (Throwable)e);
        }
        catch (FaultMessageException e) {
            Throwable cause = e.getCause();
            if (cause != null && this.exceptionMappings != null && this.exceptionMappings.containsKey(cause.getClass().getName())) {
                String exceptionClass = cause.getClass().getName();
                resp.setStatus(this.exceptionMappings.get(exceptionClass).intValue());
                resp.setHeader("Exception", exceptionClass);
                e.printStackTrace(resp.getWriter());
                resp.setContentType("text/plain");
                return;
            }
            throw new ServletException("Failed to deliver message.", (Throwable)e);
        }
        if (outMessage != null) {
            try {
                this.messageComposer.decompose(outMessage, wrapper);
            }
            catch (MessageDeliverException e) {
                throw new ServletException("Failed to decompose response message.", (Throwable)e);
            }
        } else {
            resp.setContentLength(0);
            resp.setStatus(204);
            return;
        }
    }

    private ConfigTree toConfigTree(ServletConfig config) {
        ConfigTree configTree = new ConfigTree("config");
        Enumeration configNames = config.getInitParameterNames();
        while (configNames.hasMoreElements()) {
            String name = (String)configNames.nextElement();
            configTree.setAttribute(name, config.getInitParameter(name));
        }
        return configTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStaticAsyncResponse(String payloadPath) throws ConfigurationException {
        InputStream stream = ClassUtil.getResourceAsStream(payloadPath, HttpGatewayServlet.class);
        if (stream == null) {
            throw new ConfigurationException("Failed to access static HTTP response payload file '" + payloadPath + "' on classpath.");
        }
        try {
            byte[] byArray = StreamUtils.readStream(stream);
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)("Unexpected Error closing static HTTP response payload file '" + payloadPath + "' "), (Throwable)e);
            }
        }
    }
}

