/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.lifecycle.LifecycleController;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleAdapter;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleEventListener;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleState;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleStateEvent;

public abstract class AbstractManagedLifecycle
implements ManagedLifecycle {
    private static final Logger logger = Logger.getLogger(AbstractManagedLifecycle.class);
    public static final String PARAM_TERMINATION_PERIOD = "terminationPeriod";
    private final Lock stateLock = new ReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();
    private transient ManagedLifecycleState state = ManagedLifecycleState.CONSTRUCTED;
    private long terminationPeriod = 60000L;
    private Set<ManagedLifecycleEventListener> listeners = new CopyOnWriteArraySet<ManagedLifecycleEventListener>();
    private final ConfigTree config;
    private LifecycleController lifecycleController;

    protected AbstractManagedLifecycle(ConfigTree config) throws ConfigurationException {
        String terminationPeriodVal = config.getAttribute(PARAM_TERMINATION_PERIOD);
        if (terminationPeriodVal != null) {
            try {
                this.terminationPeriod = Long.parseLong(terminationPeriodVal) * 1000L;
            }
            catch (NumberFormatException nfe) {
                throw new ConfigurationException("Failed to parse terminationPeriod value of " + terminationPeriodVal);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("terminationPeriod value " + this.terminationPeriod));
        }
        this.config = config;
        this.lifecycleController = new LifecycleController(new LifecycleControllerAdapter());
    }

    public final void initialise() throws ManagedLifecycleException {
        if (!ManagedLifecycleState.INITIALISED.equals((Object)this.getState())) {
            this.changeState(ManagedLifecycleState.INITIALISING);
            try {
                this.doInitialise();
                this.changeState(ManagedLifecycleState.INITIALISED);
                this.lifecycleController.registerMBean();
            }
            catch (ManagedLifecycleException mle) {
                this.changeState(ManagedLifecycleState.DESTROYED);
                throw mle;
            }
            catch (Exception ex) {
                logger.warn((Object)"Unexpected exception caught while initialisation", (Throwable)ex);
                this.changeState(ManagedLifecycleState.DESTROYED);
                throw new ManagedLifecycleException(ex);
            }
        }
    }

    protected abstract void doInitialise() throws ManagedLifecycleException;

    public final void start() throws ManagedLifecycleException {
        if (!ManagedLifecycleState.STARTED.equals((Object)this.getState())) {
            this.changeState(ManagedLifecycleState.STARTING);
            try {
                this.doStart();
                this.changeState(ManagedLifecycleState.STARTED);
                this.lifecycleController.setStartTime(System.currentTimeMillis());
            }
            catch (ManagedLifecycleException mle) {
                this.changeState(ManagedLifecycleState.STOPPED);
                throw mle;
            }
            catch (Exception ex) {
                logger.warn((Object)"Unexpected exception caught while starting", (Throwable)ex);
                this.changeState(ManagedLifecycleState.STOPPED);
                throw new ManagedLifecycleException(ex);
            }
        }
    }

    protected abstract void doStart() throws ManagedLifecycleException;

    public final void stop() throws ManagedLifecycleException {
        if (!ManagedLifecycleState.STOPPED.equals((Object)this.getState())) {
            this.changeState(ManagedLifecycleState.STOPPING);
            try {
                this.doStop();
            }
            catch (ManagedLifecycleException mle) {
                throw mle;
            }
            catch (Exception ex) {
                logger.warn((Object)"Unexpected exception caught while stopping", (Throwable)ex);
                throw new ManagedLifecycleException(ex);
            }
            finally {
                this.changeState(ManagedLifecycleState.STOPPED);
                this.lifecycleController.unsetStartTime();
            }
        }
    }

    protected abstract void doStop() throws ManagedLifecycleException;

    public final void destroy() throws ManagedLifecycleException {
        if (!ManagedLifecycleState.DESTROYED.equals((Object)this.getState())) {
            this.changeState(ManagedLifecycleState.DESTROYING);
            this.lifecycleController.unregisterMBean();
            try {
                this.doDestroy();
            }
            catch (ManagedLifecycleException mle) {
                throw mle;
            }
            catch (Exception ex) {
                logger.warn((Object)"Unexpected exception caught while destroying", (Throwable)ex);
                throw new ManagedLifecycleException(ex);
            }
            finally {
                this.changeState(ManagedLifecycleState.DESTROYED);
            }
        }
    }

    protected abstract void doDestroy() throws ManagedLifecycleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedLifecycleState getState() {
        this.stateLock.lock();
        try {
            ManagedLifecycleState managedLifecycleState = this.state;
            return managedLifecycleState;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(ManagedLifecycleState newState) throws ManagedLifecycleException {
        ManagedLifecycleState origState;
        this.stateLock.lock();
        try {
            if (!this.state.canTransition(newState)) {
                throw new ManagedLifecycleException("Invalid state change from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
            }
            origState = this.state;
            this.state = newState;
            this.stateChanged.signalAll();
        }
        finally {
            this.stateLock.unlock();
        }
        this.fireStateChangedEvent(origState, newState);
    }

    protected long getTerminationPeriod() {
        return this.terminationPeriod;
    }

    public boolean waitUntilDestroyed() {
        return this.waitUntilDestroyed(this.getTerminationPeriod());
    }

    public boolean waitUntilDestroyed(long transitionPeriod) {
        return this.waitUntilState(ManagedLifecycleState.DESTROYED, transitionPeriod);
    }

    protected boolean waitUntilState(ManagedLifecycleState state, long transitionPeriod) {
        return this.waitForStateChange(state, transitionPeriod, true);
    }

    protected boolean waitUntilNotState(ManagedLifecycleState state, long transitionPeriod) {
        return this.waitForStateChange(state, transitionPeriod, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForStateChange(ManagedLifecycleState state, long transitionPeriod, boolean equality) {
        this.stateLock.lock();
        try {
            if (equality ^ this.state == state) {
                long delay;
                long end = System.currentTimeMillis() + transitionPeriod;
                while (equality ^ this.state == state && (delay = end - System.currentTimeMillis()) > 0L) {
                    this.stateChanged.await(delay, TimeUnit.MILLISECONDS);
                }
            }
            boolean end = !(equality ^ this.state == state);
            this.stateLock.unlock();
            return end;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Interrupted while waiting for state change");
                }
                this.stateLock.lock();
                try {
                    boolean bl = this.state == state;
                    return bl;
                }
                finally {
                    this.stateLock.unlock();
                }
            }
        }
    }

    public void addManagedLifecycleEventListener(ManagedLifecycleEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeManagedLifecycleEventListener(ManagedLifecycleEventListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStateChangedEvent(ManagedLifecycleState origState, ManagedLifecycleState newState) {
        if (this.listeners.size() > 0) {
            ManagedLifecycleStateEvent event = new ManagedLifecycleStateEvent(this, origState, newState);
            for (ManagedLifecycleEventListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.state = ManagedLifecycleState.CONSTRUCTED;
    }

    public ConfigTree getConfig() {
        return this.config;
    }

    private final class LifecycleControllerAdapter
    implements ManagedLifecycleAdapter {
        private LifecycleControllerAdapter() {
        }

        public void start() throws ManagedLifecycleException {
            AbstractManagedLifecycle.this.start();
        }

        public void stop() throws ManagedLifecycleException {
            AbstractManagedLifecycle.this.stop();
        }

        public ManagedLifecycleState getState() {
            return AbstractManagedLifecycle.this.getState();
        }

        public ConfigTree getConfig() {
            return AbstractManagedLifecycle.this.getConfig();
        }
    }
}

