/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.lifecycle.AbstractThreadedManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadState;
import org.jboss.soa.esb.listeners.message.ActionProcessingPipeline;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.Util;

public class MessageAwareListener
extends AbstractThreadedManagedLifecycle {
    private static final long MIN_ERROR_DELAY = 1000L;
    private static final long MAX_ERROR_DELAY = 32000L;
    private ActionProcessingPipeline pipeline;
    private long errorDelay;
    private TransactionStrategy transactionStrategy;
    private boolean transactional = false;
    private boolean rollbackOnPipelineFaults = true;
    private ConfigTree _config;
    private String _eprCategoryName;
    private String _eprName;
    private EPR _epr;
    private int _maxThreads;
    private int _defaultMaxThreads = 1;
    private long _latencySecs;
    private long _pauseLapseInMillis = 50L;
    private ExecutorService _execService;
    private byte[] _synchThreads = new byte[0];
    private int _qRunningThreads;
    private Logger _logger = Logger.getLogger(MessageAwareListener.class);
    private PickUpOnlyCourier _pickUpCourier;

    public MessageAwareListener(ConfigTree config) throws ConfigurationException {
        super(config);
        this._config = config;
        this.checkMyParms();
    }

    protected void checkMyParms() throws ConfigurationException {
        this._eprCategoryName = this._config.getAttribute("service-category");
        this._eprName = this._config.getAttribute("service-name");
        String maxThreadVal = this._config.getAttribute("maxThreads");
        if (!Util.isNullString(maxThreadVal)) {
            try {
                this._maxThreads = Integer.parseInt(maxThreadVal);
            }
            catch (NumberFormatException nfe) {
                this._maxThreads = this._defaultMaxThreads;
                this._logger.warn((Object)("Invalid maxThreads attribute, defaulting to <" + this._maxThreads + ">"));
            }
        }
        if (Util.isNullString(this._eprCategoryName)) {
            throw new ConfigurationException("Missing or invalid service-category");
        }
        if (Util.isNullString(this._eprName)) {
            throw new ConfigurationException("Missing or invalid service-name");
        }
        ConfigTree eprElement = this._config.getFirstChild("EPR");
        if (null == eprElement) {
            throw new ConfigurationException("Missing or invalid EPR element");
        }
        this._epr = ListenerUtil.assembleEpr(eprElement);
        String latency = this._config.getAttribute("pollLatencySeconds");
        long lSeconds = 10L;
        if (null != latency) {
            try {
                lSeconds = Integer.parseInt(latency);
            }
            catch (NumberFormatException e) {
                this._logger.warn((Object)("Invalid number format <" + latency + "> using default value (" + lSeconds + ")"));
            }
        }
        this._latencySecs = lSeconds;
        this.transactional = this._config.getBooleanAttribute("transacted", false);
        this.transactionStrategy = TransactionStrategy.getTransactionStrategy(this.transactional);
        this.rollbackOnPipelineFaults = this._config.getBooleanAttribute("rollbackOnPipelineFaults", true);
    }

    protected void doInitialise() throws ManagedLifecycleException {
        ActionProcessingPipeline pipeline;
        try {
            pipeline = new ActionProcessingPipeline(this._config);
            pipeline.setTransactional(this.transactional);
            pipeline.initialise();
        }
        catch (ConfigurationException ce) {
            throw new ManagedLifecycleException("Error configuring action processing pipeline", ce);
        }
        try {
            RegistryUtil.register(this._config, this._epr);
        }
        catch (RegistryException re) {
            throw new ManagedLifecycleException("Unexpected error during registration for epr " + this._epr, re);
        }
        this.pipeline = pipeline;
        try {
            PickUpOnlyCourier pickUpCourier = this.getCourier();
            this.cleanCourier(pickUpCourier);
        }
        catch (MalformedEPRException mepre) {
            RegistryUtil.unregister(this._eprCategoryName, this._eprName, this._epr);
            throw new ManagedLifecycleException("Malformed EPR: " + this._epr);
        }
        catch (CourierException ce) {
            RegistryUtil.unregister(this._eprCategoryName, this._eprName, this._epr);
            throw new ManagedLifecycleException("No appropriate courier can be obtained for " + this._epr, ce);
        }
    }

    protected void doStart() throws ManagedLifecycleException {
        this.checkExecutorTermination();
        this._execService = Executors.newFixedThreadPool(this._maxThreads);
        super.doStart();
    }

    protected void doRun() {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("doRun() method of " + this.getClass().getSimpleName() + " started on thread " + Thread.currentThread().getName()));
        }
        while (this.isRunning()) {
            if (!this.waitForThread(this._pauseLapseInMillis)) continue;
            this.waitForEventAndProcess(100L);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("run() method of " + this.getClass().getSimpleName() + " finished on thread " + Thread.currentThread().getName()));
        }
    }

    protected void doStop() throws ManagedLifecycleException {
        super.doStop();
        this._execService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEventAndProcess(long maxWaitMillis) {
        Message message = null;
        boolean problem = false;
        PickUpOnlyCourier pickUpCourier = null;
        try {
            this.transactionStrategy.begin();
            pickUpCourier = this.getCourier();
            message = maxWaitMillis > 0L ? pickUpCourier.pickup(maxWaitMillis) : null;
            this.errorDelay = 0L;
        }
        catch (TransactionStrategyException ex) {
            this._logger.error((Object)"Could not begin transaction!");
            problem = true;
            return;
        }
        catch (MalformedEPRException e) {
            problem = true;
            return;
        }
        catch (CourierTimeoutException e) {
            problem = true;
            return;
        }
        catch (FaultMessageException fme) {
            message = fme.getReturnedMessage();
        }
        catch (CourierException e) {
            this._logger.debug((Object)"Courier Exception", (Throwable)e);
            if (this.errorDelay == 0L) {
                this.errorDelay = 1000L;
            } else if (this.errorDelay < 32000L) {
                this.errorDelay <<= 1;
            }
            this._logger.warn((Object)("Error processing courier, backing off for " + this.errorDelay + " milliseconds"));
            boolean waitForRunningStateChange = this.waitForRunningStateChange(ManagedLifecycleThreadState.STOPPING, this.errorDelay);
            this._logger.info((Object)("State reached : " + waitForRunningStateChange));
            problem = true;
            return;
        }
        finally {
            if (problem || message == null) {
                this.cleanCourier(pickUpCourier);
                this.rollbackTransaction();
            }
        }
        if (null != message) {
            try {
                Message pipelineMessage = message;
                Object txHandle = this.transactionStrategy.suspend();
                TransactionalRunner txRunner = new TransactionalRunner(pickUpCourier, pipelineMessage, txHandle);
                this.updateThreadCount(1);
                this._execService.execute(txRunner);
            }
            catch (TransactionStrategyException ex) {
                this._logger.warn((Object)"Caught transaction related exception: ", (Throwable)ex);
                this.cleanCourier(pickUpCourier);
                this.rollbackTransaction();
            }
        }
    }

    protected void doThreadedDestroy() throws ManagedLifecycleException {
        try {
            this.checkExecutorTermination();
        }
        catch (ManagedLifecycleException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this._logger.warn((Object)("Caught throwable during shutdown: " + ex));
        }
        this.pipeline.destroy();
        this.pipeline = null;
        CourierUtil.cleanCourier(this._pickUpCourier);
        RegistryUtil.unregister(this._eprCategoryName, this._eprName, this._epr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExecutorTermination() throws ManagedLifecycleException {
        if (this._execService != null) {
            try {
                try {
                    if (!this._execService.awaitTermination(this.getTerminationPeriod(), TimeUnit.MILLISECONDS)) {
                        throw new ManagedLifecycleException("Tasks remain active in executor");
                    }
                }
                catch (InterruptedException ie) {
                    throw new ManagedLifecycleException("Interrupted waiting for active tasks to terminate");
                }
            }
            finally {
                this._execService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForThread(long delay) {
        boolean result = true;
        byte[] byArray = this._synchThreads;
        synchronized (this._synchThreads) {
            if (this._qRunningThreads >= this._maxThreads) {
                try {
                    this._synchThreads.wait(delay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                result = this._qRunningThreads < this._maxThreads;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreadCount(Integer i) {
        byte[] byArray = this._synchThreads;
        synchronized (this._synchThreads) {
            this._qRunningThreads += i.intValue();
            if (this._qRunningThreads < this._maxThreads) {
                this._synchThreads.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void rollbackTransaction() {
        try {
            this.transactionStrategy.rollbackOnly();
            this.transactionStrategy.terminate();
        }
        catch (Throwable ex) {
            this._logger.warn((Object)"Problem while attempting to rollback transaction!");
        }
    }

    private PickUpOnlyCourier getCourier() throws MalformedEPRException, CourierException {
        PickUpOnlyCourier pickUpCourier = this._pickUpCourier;
        if (this.transactional || pickUpCourier == null) {
            pickUpCourier = CourierFactory.getPickupCourier(this._epr);
            try {
                Method setPollLatency = pickUpCourier.getClass().getMethod("setPollLatency", Long.class);
                setPollLatency.invoke((Object)pickUpCourier, new Long(1000L * this._latencySecs));
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (Throwable th) {
                CourierUtil.cleanCourier(pickUpCourier);
                throw new CourierException("Problems invoking setPollLatency(long)", th);
            }
            if (!this.transactional) {
                this._pickUpCourier = pickUpCourier;
            }
        }
        return pickUpCourier;
    }

    private void cleanCourier(PickUpOnlyCourier pickUpOnlyCourier) {
        if (this.transactional) {
            CourierUtil.cleanCourier(pickUpOnlyCourier);
        }
    }

    class TransactionalRunner
    implements Runnable {
        private PickUpOnlyCourier _courier;
        private Message _pipelineMessage;
        private Object _txHandle;

        public TransactionalRunner(PickUpOnlyCourier courier, Message pipelineMessage, Object txHandle) {
            this._courier = courier;
            this._pipelineMessage = pipelineMessage;
            this._txHandle = txHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean problem = false;
            try {
                if (this._txHandle != null) {
                    MessageAwareListener.this.transactionStrategy.resume(this._txHandle);
                }
                boolean bl = problem = MessageAwareListener.this.rollbackOnPipelineFaults && !MessageAwareListener.this.pipeline.process(this._pipelineMessage);
                if (!problem) {
                    MessageAwareListener.this.transactionStrategy.terminate();
                }
            }
            catch (TransactionStrategyException ex) {
                problem = true;
                MessageAwareListener.this._logger.warn((Object)"TransactionalRunner caught transaction exception: ", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                problem = true;
                throw ex;
            }
            catch (Throwable ex) {
                problem = true;
                MessageAwareListener.this._logger.warn((Object)"TransactionalRunner caught throwable: ", ex);
            }
            finally {
                MessageAwareListener.this.cleanCourier(this._courier);
                if (problem) {
                    MessageAwareListener.this.rollbackTransaction();
                }
                MessageAwareListener.this.updateThreadCount(-1);
            }
        }
    }
}

