/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.security.SecurityConfig;

public class SecurityConfigUtil {
    private SecurityConfigUtil() {
    }

    public static SecurityConfig createSecurityConfig(ConfigTree securityFragment) {
        ConfigTree[] children;
        String moduleName = securityFragment.getAttribute("moduleName");
        SecurityConfig.Builder builder = new SecurityConfig.Builder(moduleName);
        builder.runAs(securityFragment.getAttribute("runAs"));
        builder.useCallerIdentity(securityFragment.getAttribute("useCallersIdentity"));
        builder.rolesAllowed(securityFragment.getAttribute("rolesAllowed"));
        builder.callBackhandler(securityFragment.getAttribute("callbackHandler"));
        for (ConfigTree configTree : children = securityFragment.getChildren("property")) {
            String propertyName = configTree.getAttribute("name");
            String propertyValue = configTree.getAttribute("value");
            builder.property(propertyName, propertyValue);
        }
        return builder.build();
    }
}

