/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMetaClass;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.TwoOperandInstr;
import org.jruby.compiler.ir.operands.ClassMetaObject;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineClassInstr
extends TwoOperandInstr {
    public DefineClassInstr(ClassMetaObject cmo, Operand superClass) {
        super(Operation.DEF_CLASS, null, cmo, superClass);
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineClassInstr((ClassMetaObject)this.getOperand1(), this.getOperand2().cloneForInlining(ii));
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        RubyClass module;
        Ruby runtime2 = interp.getRuntime();
        ClassMetaObject cmo = (ClassMetaObject)this.getOperand1();
        IRScope scope = cmo.scope;
        RubyModule container = cmo.getContainer(interp, runtime2);
        if (scope instanceof IRMetaClass) {
            module = container.getMetaClass();
        } else {
            RubyClass sc = (RubyClass)this.getOperand2().retrieve(interp);
            module = container.defineOrGetClassUnder(scope.getName(), sc == null ? runtime2.getObject() : sc);
        }
        cmo.interpretBody(interp, interp.getContext(), module);
        return null;
    }

    public String toString() {
        return "\t" + (Object)((Object)this.operation) + "(" + this.getOperand1() + ", " + this.getOperand2() + ")";
    }
}

