/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class CSVWriter {
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private String lineEnd;
    public static final char ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char c) {
        this(writer, c, '\"');
    }

    public CSVWriter(Writer writer, char c, char c2) {
        this(writer, c, c2, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char c, char c2, String string) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = c;
        this.quotechar = c2;
        this.lineEnd = string;
    }

    public void writeAll(List list) {
        for (String[] stringArray : list) {
            this.writeNext(stringArray);
        }
    }

    protected void writeColumnNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1);
        }
        this.writeNext(stringArray);
    }

    public void writeAll(ResultSet resultSet, boolean bl) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (bl) {
            this.writeColumnNames(resultSetMetaData);
        }
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = CSVWriter.getColumnValue(resultSet, resultSetMetaData.getColumnType(i + 1), i + 1);
            }
            this.writeNext(stringArray);
        }
    }

    private static String getColumnValue(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        String string = "";
        switch (n) {
            case -7: {
                Object object = resultSet.getObject(n2);
                string = String.valueOf(object);
                break;
            }
            case 16: {
                boolean bl = resultSet.getBoolean(n2);
                if (resultSet.wasNull()) break;
                string = Boolean.valueOf(bl).toString();
                break;
            }
            case 2005: {
                string = CSVWriter.read(resultSet.getClob(n2));
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "" + resultSet.getBigDecimal(n2).doubleValue();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = resultSet.getInt(n2);
                if (resultSet.wasNull()) break;
                string = "" + n3;
                break;
            }
            case 2000: {
                Object object = resultSet.getObject(n2);
                if (object == null) break;
                string = String.valueOf(object);
                break;
            }
            case 91: {
                string = resultSet.getDate(n2).toString();
                break;
            }
            case 92: {
                Time time = resultSet.getTime(n2);
                string = time.toString();
                break;
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(n2);
                string = timestamp.toString();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = resultSet.getString(n2);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String read(Clob clob) throws SQLException, IOException {
        StringBuffer stringBuffer = new StringBuffer((int)clob.length());
        Reader reader = clob.getCharacterStream();
        char[] cArray = new char[2048];
        int n = 0;
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public void writeNext(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i != 0) {
                stringBuffer.append(this.separator);
            }
            if ((string = stringArray[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                stringBuffer.append(this.quotechar);
            }
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == this.quotechar) {
                    stringBuffer.append('\"').append(c);
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append('\"').append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
            if (this.quotechar == '\u0000') continue;
            stringBuffer.append(this.quotechar);
        }
        stringBuffer.append(this.lineEnd);
        this.pw.write(stringBuffer.toString());
    }

    public void close() throws IOException {
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }
}

