/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIReportPanel;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.wsI.testing.x2003.x03.common.AddStyleSheet;
import org.wsI.testing.x2004.x07.analyzerConfig.AssertionResults;
import org.wsI.testing.x2004.x07.analyzerConfig.Configuration;
import org.wsI.testing.x2004.x07.analyzerConfig.ConfigurationDocument;
import org.wsI.testing.x2004.x07.analyzerConfig.ReportFile;
import org.wsI.testing.x2004.x07.analyzerConfig.WsdlElementReference;
import org.wsI.testing.x2004.x07.analyzerConfig.WsdlElementType;
import org.wsI.testing.x2004.x07.analyzerConfig.WsdlReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSIAnalyzeAction
extends AbstractToolsAction<Interface> {
    public static final Logger log = Logger.getLogger(WSIAnalyzeAction.class);
    private String configFile;

    public WSIAnalyzeAction(Interface iface) {
        super(iface, "Check WSI Compliance", "Validate this WSDL for WSI Basic Profile compliance");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu W"));
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost) throws Exception {
        String wsiDir = SoapUI.getSettings().getString(WSISettings.WSI_LOCATION, null);
        if (Tools.isEmpty(wsiDir)) {
            UISupport.showErrorMessage("WSI Test Tools directory must be set in global preferences");
            if (UISupport.getMainFrame() != null && SoapUIPreferencesAction.getInstance().show("WS-I Settings")) {
                wsiDir = SoapUI.getSettings().getString(WSISettings.WSI_LOCATION, null);
            }
        }
        if (Tools.isEmpty(wsiDir)) {
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        File reportFile = File.createTempFile("wsi-report", ".xml");
        ArgumentBuilder args = this.buildArgs(reportFile);
        builder.command(args.getArgs());
        File wsiToolDir = new File(wsiDir + File.separatorChar + "cs" + File.separatorChar + "bin");
        if (!wsiToolDir.exists()) {
            wsiToolDir = new File(wsiDir + File.separatorChar + "java" + File.separatorChar + "bin");
        }
        builder.directory(wsiToolDir);
        toolHost.run(new WSIProcessToolRunner(builder, reportFile));
    }

    private ArgumentBuilder buildArgs(File reportFile) throws IOException {
        Settings settings = ((Interface)this.modelItem).getSettings();
        ConfigurationDocument configDoc = this.createConfigFile(reportFile, settings);
        this.configFile = configDoc.toString();
        File file = File.createTempFile("wsi-analyzer-config", ".xml");
        configDoc.save(file);
        ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
        builder.startScript("Analyzer", "", ".sh");
        builder.addArgs("-config", file.getAbsolutePath());
        if (settings.getBoolean(WSISettings.ASSERTION_DESCRIPTION)) {
            builder.addArgs("-assertionDescription", "true");
        }
        return builder;
    }

    private ConfigurationDocument createConfigFile(File reportFile, Settings settings) {
        ConfigurationDocument configDoc = ConfigurationDocument.Factory.newInstance();
        Configuration config = configDoc.addNewConfiguration();
        config.setVerbose(settings.getBoolean(WSISettings.VERBOSE));
        AssertionResults results = config.addNewAssertionResults();
        results.setType(AssertionResults.Type.Enum.forString((String)settings.getString(WSISettings.RESULTS_TYPE, AssertionResults.Type.ONLY_FAILED.toString())));
        results.setMessageEntry(settings.getBoolean(WSISettings.MESSAGE_ENTRY));
        results.setFailureMessage(settings.getBoolean(WSISettings.FAILURE_MESSAGE));
        results.setAssertionDescription(settings.getBoolean(WSISettings.ASSERTION_DESCRIPTION));
        ReportFile report = config.addNewReportFile();
        report.setLocation(reportFile.getAbsolutePath());
        report.setReplace(true);
        AddStyleSheet stylesheet = report.addNewAddStyleSheet();
        stylesheet.setHref(".\\..\\common\\Profiles\\SSBP10_BP11_TAD.xml");
        stylesheet.setType("text/xsl");
        stylesheet.setAlternate(false);
        config.setTestAssertionsFile("../../common/profiles/SSBP10_BP11_TAD.xml");
        WsdlReference wsdlRef = config.addNewWsdlReference();
        StringToStringMap values = new StringToStringMap();
        values.put("WSDL", ((Interface)this.modelItem).getDefinition());
        values.put("Use cached WSDL", Boolean.toString(((Interface)this.modelItem).isCached()));
        wsdlRef.setWsdlURI(this.getWsdlUrl(values));
        WsdlElementReference wsdlElement = wsdlRef.addNewWsdlElement();
        wsdlElement.setType(WsdlElementType.BINDING);
        wsdlElement.setStringValue(((Interface)this.modelItem).getBindingName().getLocalPart());
        wsdlElement.setNamespace(((Interface)this.modelItem).getBindingName().getNamespaceURI());
        return configDoc;
    }

    public static File transformReport(File reportFile) throws Exception {
        String dir = SoapUI.getSettings().getString(WSISettings.WSI_LOCATION, null);
        File xsltFile = new File(dir + File.separatorChar + "common" + File.separatorChar + "xsl" + File.separatorChar + "report.xsl");
        StreamSource xmlSource = new StreamSource(reportFile);
        StreamSource xsltSource = new StreamSource(xsltFile);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        String outputFolder = SoapUI.getSettings().getString(WSISettings.OUTPUT_FOLDER, null);
        File output = outputFolder == null || outputFolder.trim().length() == 0 ? null : new File(outputFolder);
        File tempFile = File.createTempFile("wsi-report", ".html", output);
        trans.transform(xmlSource, new StreamResult(tempFile));
        log.info((Object)("WSI Report created at [" + tempFile.getAbsolutePath() + "]"));
        return tempFile;
    }

    private class WSIProcessToolRunner
    extends ProcessToolRunner {
        private File reportFile;

        public WSIProcessToolRunner(ProcessBuilder builder, File reportFile) {
            super(builder, "WSI Analyzer", WSIAnalyzeAction.this.modelItem);
            this.reportFile = reportFile;
        }

        public String getDescription() {
            return "Running WSI Analysis tools..";
        }

        protected void afterRun(int exitCode, RunnerContext context) {
            if (exitCode == 0 && context.getStatus() == RunnerContext.RunnerStatus.FINISHED) {
                try {
                    this.reportFile = WSIAnalyzeAction.transformReport(this.reportFile);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            WSIReportPanel panel = new WSIReportPanel(WSIProcessToolRunner.this.reportFile, WSIAnalyzeAction.this.configFile, null);
                            panel.setPreferredSize(new Dimension(600, 400));
                            UISupport.showDesktopPanel(new DefaultDesktopPanel("WS-I Report", "WS-I Report for Interface [" + ((Interface)WSIAnalyzeAction.this.modelItem).getName() + "]", panel));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UISupport.showErrorMessage(e);
                        }
                    }
                });
            }
            WSIAnalyzeAction.this.closeDialog();
        }

        public boolean showLog() {
            return ((Interface)WSIAnalyzeAction.this.modelItem).getSettings().getBoolean(WSISettings.SHOW_LOG);
        }
    }
}

