/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.operation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.iface.AbstractSwingAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToMockServiceAction
extends AbstractSwingAction<WsdlOperation> {
    private static final String CREATE_MOCKSUITE_OPTION = "Create new..";
    private final WsdlRequest request;

    public AddToMockServiceAction(WsdlOperation operation, WsdlRequest request) {
        super("Add to MockService", request == null ? "Add this operation to a MockService" : "Adds the current response to a MockService", "/addToMockService.gif", operation);
        this.request = request;
    }

    public AddToMockServiceAction(WsdlOperation operation) {
        this(operation, null);
    }

    public AddToMockServiceAction(WsdlRequest request) {
        this(request.getOperation(), request);
    }

    @Override
    public void actionPerformed(ActionEvent arg0, WsdlOperation operation) {
        String title = this.getName();
        if (this.request != null && this.request.getResponse() == null && !UISupport.confirm("Request is missing response, create default mock response instead?", title)) {
            return;
        }
        WsdlMockService mockService = null;
        WsdlProject project = operation.getInterface().getProject();
        while (mockService == null) {
            if (project.getMockServiceCount() > 0) {
                String[] mockServices = ModelSupport.getNames(project.getMockServices(), new String[]{CREATE_MOCKSUITE_OPTION});
                String option = UISupport.prompt("Select MockService for MockOperation", title, mockServices);
                if (option == null) {
                    return;
                }
                mockService = project.getMockServiceByName(option);
            }
            if (mockService == null) {
                String mockServiceName = UISupport.prompt("Enter name of new MockService", title, "MockService " + (project.getMockServiceCount() + 1));
                if (mockServiceName == null || mockServiceName.trim().length() == 0) {
                    return;
                }
                mockService = project.addNewMockService(mockServiceName);
            }
            if (!mockService.hasMockOperation(operation)) continue;
            UISupport.showErrorMessage("MockService [" + mockService.getName() + "] already has a MockOperation for [" + operation.getName() + "], please select another MockService");
            mockService = null;
        }
        WsdlMockOperation mockOperation = mockService.addNewMockOperation(operation);
        WsdlMockResponse mockResponse = mockOperation.addNewMockResponse("Response 1", false);
        if (this.request != null && this.request.getResponse() != null) {
            Attachment[] attachments;
            WsdlResponse response = this.request.getResponse();
            mockResponse.setResponseContent(response.getContentAsString());
            for (Attachment attachment : attachments = response.getAttachments()) {
                mockResponse.addAttachment(attachment);
            }
            if (UISupport.confirm("Add HTTP Headers to MockResponse", title)) {
                mockResponse.setResponseHeaders(response.getResponseHeaders());
            }
        } else {
            mockResponse.setResponseContent(operation.createResponse(true));
        }
        if (UISupport.confirm("Open MockResponse editor?", title)) {
            SoapUI.getDesktop().showDesktopPanel(mockResponse);
        }
    }
}

