/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.support.Tools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PostResponseDataSource
implements DataSource {
    private final TimeablePostMethod postMethod;
    private byte[] data;

    public PostResponseDataSource(TimeablePostMethod postMethod) {
        this.postMethod = postMethod;
        try {
            this.data = Tools.readAll(postMethod.getResponseBodyAsStream(), 0L).toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getDataSize() {
        return this.data == null ? -1L : (long)this.data.length;
    }

    public String getContentType() {
        return this.postMethod.getResponseHeader("Content-Type").getValue();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return this.postMethod.getName() + " response for " + this.postMethod.getPath().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

