/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.DefaultHyperlinkListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.ProgressDialog;
import com.eviware.x.dialogs.XDialogs;
import com.eviware.x.dialogs.XProgressDialog;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SwingDialogs
implements XDialogs {
    private Component parent;
    private JDialog extendedInfoDialog;
    private Boolean extendedInfoResult;

    public SwingDialogs(Component parent) {
        this.parent = parent;
    }

    public void showErrorMessage(String message) {
        if (this.parent == null) {
            return;
        }
        JOptionPane.showMessageDialog(this.parent, message, "Error", 0);
    }

    public boolean confirm(String question, String title) {
        return JOptionPane.showConfirmDialog(this.parent, question, title, 0) == 0;
    }

    public String prompt(String question, String title, String value) {
        return (String)JOptionPane.showInputDialog(this.parent, question, title, 3, null, null, value);
    }

    public String prompt(String question, String title) {
        return JOptionPane.showInputDialog(this.parent, question, title, 3);
    }

    public void showInfoMessage(String message) {
        this.showInfoMessage(message, "Information");
    }

    public void showInfoMessage(String message, String title) {
        JOptionPane.showMessageDialog(this.parent, message, title, 1);
    }

    public Object prompt(String question, String title, Object[] objects) {
        Object result = JOptionPane.showInputDialog(this.parent, question, title, 2, null, objects, null);
        return result;
    }

    public Object prompt(String question, String title, Object[] objects, String value) {
        Object result = JOptionPane.showInputDialog(this.parent, question, title, 2, null, objects, value);
        return result;
    }

    public Boolean confirmOrCancel(String question, String title) {
        int result = JOptionPane.showConfirmDialog(this.parent, question, title, 1);
        if (result == 2) {
            return null;
        }
        return result == 0;
    }

    public XProgressDialog createProgressDialog(String label, int length, String initialValue, boolean canCancel) {
        return new ProgressDialog("Progress", label, length, initialValue, canCancel);
    }

    public void showExtendedInfo(String title, String description, String content, Dimension size) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("OK")));
        this.showExtendedInfo(title, description, content, buttonBar, size);
    }

    private void showExtendedInfo(String title, String description, String content, JPanel buttonBar, Dimension size) {
        this.extendedInfoDialog = new JDialog(UISupport.getMainFrame(), title);
        this.extendedInfoDialog.setModal(true);
        JPanel panel = new JPanel(new BorderLayout());
        if (description != null) {
            panel.add(UISupport.buildDescription(title, description, null), "North");
        }
        JEditorPane editorPane = new JEditorPane("text/html", content);
        editorPane.setCaretPosition(0);
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new DefaultHyperlinkListener(editorPane));
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        panel.add(scrollPane);
        buttonBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        panel.add((Component)buttonBar, "South");
        this.extendedInfoDialog.getRootPane().setContentPane(panel);
        if (size == null) {
            this.extendedInfoDialog.setSize(400, 300);
        } else {
            this.extendedInfoDialog.setSize(size);
        }
        UISupport.showDialog(this.extendedInfoDialog);
    }

    public boolean confirmExtendedInfo(String title, String description, String content, Dimension size) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("OK")), (JButton)new JButton(new CancelAction("Cancel")));
        this.showExtendedInfo(title, description, content, buttonBar, size);
        return this.extendedInfoResult == null ? false : this.extendedInfoResult;
    }

    public Boolean confirmOrCancleExtendedInfo(String title, String description, String content, Dimension size) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("Yes")), (JButton)new JButton(new NoAction("No")), (JButton)new JButton(new CancelAction("Cancel")));
        this.showExtendedInfo(title, description, content, buttonBar, size);
        return this.extendedInfoResult;
    }

    private final class CancelAction
    extends AbstractAction {
        public CancelAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = null;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }

    private final class NoAction
    extends AbstractAction {
        public NoAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = false;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }

    private final class OkAction
    extends AbstractAction {
        public OkAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            SwingDialogs.this.extendedInfoResult = true;
            SwingDialogs.this.extendedInfoDialog.setVisible(false);
        }
    }
}

