/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.ws;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;

import javax.xml.soap.SOAPMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 * @author Jeff Yu <cyu@redhat.com>
 */
public class JavaUtils
{ 
  protected static final Log log = LogFactory.getLog(JavaUtils.class);
	
  public static boolean isJBossRepositoryClassLoader(ClassLoader loader)
  {
    Class clazz = loader.getClass();
    while (!clazz.getName().startsWith("java"))
    {
      if ("org.jboss.mx.loading.RepositoryClassLoader".equals(clazz.getName()))
        return true;
      clazz = clazz.getSuperclass();
    }

    return false;
  }

  /**
   * Clears black lists on a JBoss RepositoryClassLoader. This is somewhat of a hack, and
   * could be replaced with an integration module. This is needed when the following order of
   * events occur.
   *
   * <ol>
   *   <li>loadClass() returns not found</li>
   *   <li>Some call to defineClass()</li>
   * <ol>
   *
   * The CNFE triggers a black list addition, which cause the class never again to be found.
   *
   * @param loader the loader to clear black lists for
   */
  public static void clearBlacklists(ClassLoader loader)
  {
    if (isJBossRepositoryClassLoader(loader))
    {
      for(Method m : loader.getClass().getMethods())
      {
        if("clearBlackLists".equalsIgnoreCase(m.getName()))
        {
          try
          {
            m.invoke(loader);
          }
          catch (Exception e)
          {
            e.printStackTrace();
          }
        }
      }
    }
  }
  
  /**
   * Convert the SoapMessage object into String.
   * @param soapMessage
   * @return
   */
  public static String getSoapMessageASString(SOAPMessage soapMessage) {
   try {
		  ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		  soapMessage.writeTo(outputStream);
		  byte[] byteArray = outputStream.toByteArray();
		  String soapMsg = new String( byteArray, "UTF-8");
		  return soapMsg;
	} catch (Exception e) {
		log.error("Error in converting SOAPMessage into String");
	}
	return null;
  }
}
