<%@page contentType="text/xml; charset=UTF-8"%>
<%@page import="java.net.URI"%>
<%@page import="java.util.ArrayList"%>
<%@page import="java.util.List"%>
<%@page import="org.jboss.internal.soa.esb.publish.ContractInfo"%>
<%@page import="org.jboss.internal.soa.esb.publish.ContractPublisher"%>
<%@page import="org.jboss.internal.soa.esb.publish.ContractReferencePublisher"%>
<%@page import="org.jboss.internal.soa.esb.publish.Publisher"%>
<%@page import="org.jboss.internal.soa.esb.publish.ServletContractPublisher"%>
<%@page import="org.jboss.soa.esb.Service"%>
<%@page import="org.jboss.soa.esb.addressing.EPR"%>
<%@page import="org.jboss.soa.esb.listeners.config.ServicePublisher"%>
<%@page import="org.jboss.soa.esb.listeners.config.ServicePublisherContractInfoCache"%>
<%@page import="org.jboss.soa.esb.services.registry.Registry"%>
<%@page import="org.jboss.soa.esb.services.registry.RegistryException"%>
<%@page import="org.jboss.soa.esb.services.registry.RegistryFactory"%>
<%@page import="org.jboss.soa.esb.services.registry.ServiceNotFoundException"%>
<%
    Registry registry = RegistryFactory.getRegistry();
    String targetServiceCat = request.getParameter("serviceCat");
    String targetServiceName = request.getParameter("serviceName");
    String targetProtocol = request.getParameter("protocol");
    final Service service = new Service(targetServiceCat, targetServiceName) ;
    
    final List<ServicePublisher> servicePublishers = ServicePublisher.getServicePublishers(service) ;
    ContractInfo contractInfo = null;
    String contractData = "";

    List eprs;
    if (targetProtocol == null || !targetProtocol.toLowerCase().startsWith("http")) {
        // ignore for now - just return an empty list
        eprs = new ArrayList();
    } else {
        try {
            eprs = (List) registry.findEPRs(targetServiceCat, targetServiceName);
        } catch (ServiceNotFoundException e) {
            // ignore for now - just return an empty list
            eprs = new ArrayList();
        } catch (RegistryException e) {
            // ignore for now - just return an empty list
            eprs = new ArrayList();
        }
    }

    EPR contractPublisherEPR = null ;
    for (int ii = 0; ii < eprs.size(); ii++) {
        EPR epr = (EPR) eprs.get(ii);
        URI eprURI = URI.create(epr.getAddr().getAddress());
        String protocol = eprURI.getScheme();

        if (protocol.equalsIgnoreCase(targetProtocol)) {
            contractPublisherEPR = epr ;
            break;
        }
    }
    
    for (ServicePublisher servicePublisher: servicePublishers) {

        if (contractPublisherEPR != null) {
	        final ContractPublisher contractPublisher = servicePublisher.getContractPublisher() ;
	        if (contractPublisher == null) {
	            continue;
	        }
	        ServicePublisherContractInfoCache contractInfoCache = ServicePublisher.getContractInfoCache();
	        if (contractPublisher instanceof ServletContractPublisher) {
	        	contractInfo = contractInfoCache.getContractInfo(servicePublisher, contractPublisherEPR, request);
	        } else {
	        	contractInfo = contractInfoCache.getContractInfo(servicePublisher, contractPublisherEPR);
	        }
	        
	        if (contractInfo != null) {
	        	// check for a resource request
	        	boolean isResourceRequest = false;
	        	String query = request.getQueryString();
	        	if (query != null && query.toLowerCase().startsWith("wsdl")) {
	        		String resource = request.getParameter("resource");
	        		if (resource != null) {
	        			isResourceRequest = true;
	        			contractData = contractInfo.getResource(resource);
	        		}
	        	}
	        	if (!isResourceRequest) {
	        		contractData = contractInfo.getData();
	        	}
	        }
	        
	        if (contractData != null && contractData.length() > 0) {
				contractData = contractData.replaceAll( "@REQUEST_URL@", request.getRequestURL().toString() );
	        } else {
				// will trigger HttpServletResponse.SC_NOT_FOUND below
				contractPublisherEPR = null;
	        }
	        break ;
        } else {
            final Publisher publisher = servicePublisher.getPublisher() ;
            if (publisher instanceof ContractReferencePublisher) {
                final ContractReferencePublisher contractReferencePublisher = (ContractReferencePublisher)publisher ;
                final URI serviceURI = contractReferencePublisher.getServiceURI() ;
                if (serviceURI.getScheme().equalsIgnoreCase(targetProtocol)) {
	                response.sendRedirect(contractReferencePublisher.getServiceContractURI().toString()) ;
	                return ;
                }
            }
        }
    }
    // JBESB-1547 - Contract console should generate HTTP 404 when asking for non-deployed service WSDL 
    if (contractPublisherEPR == null) {
        response.sendError(HttpServletResponse.SC_NOT_FOUND);
        return;
    }
%><%=contractData%>
