package org.jboss.internal.soa.esb.publish;

import org.jboss.soa.esb.addressing.EPR;

/**
 * Contract Publisher.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public abstract interface ContractPublisher extends Publisher {

    /**
     * Get the contract information.
     * <p/>
     * A Service may publish a number of addressable endpoints. The publisher
     * will likely return different contract info depending on the endpoint EPR.
     * <p/>
     * This info can be stored and published from a global registry of some sort.
     *
     * @param epr Endpoint EPR.
     * @return Contract information.
     */
    public ContractInfo getContractInfo(EPR epr);
}
