/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.rosetta.pooling.handlers;

import javax.jms.JMSException;

import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionExceptionHandler;

/**
 * JBoss Messaging connection exception handler.
 *
 * @author <a href="mailto:Kevin.Conner@jboss.com">Kevin Conner</a>
 */
public class JBossMessagingConnectionExceptionHandler implements JmsConnectionExceptionHandler
{
    /**
     * Check the exception to see whether it indicates a connection failure
     * @param jmse The current JMS Exception
     * @return null if no connection failure, TRUE if the connection should be closed, FALSE if just cleaned up.
     */
    public Boolean isConnectionFailure(final JMSException jmse)
    {
        /*
         * JBoss Messaging can drop the connection from the server side
         * without calling back on the exception listener.  We check for
         * IllegalStateException as this appears to be the indicator
         * exception used by JBoss Messaging when the connection has disappeared.
         * 
         * We return TRUE as the connection should be closed.
         */
        Throwable cause = jmse ;
        while(cause.getCause() != null)
        {
            cause = cause.getCause() ;
        }
        return (cause instanceof IllegalStateException ? Boolean.TRUE : null) ;
    }
}
