/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import org.jboss.soa.esb.message.Message;

/**
 * Abstract class for processor actions used in a pipeline.
 * 
 * @author kevin
 */
public abstract class AbstractActionPipelineProcessor extends AbstractActionLifecycle implements ActionPipelineProcessor
{
    /**
     * Process an exception generated by the pipeline processing.
     * Invoked when the processing of a subsequent stage of the
     * pipeline generates an exception.
     * 
     * @param message The original message.
     * @param th The throwable raised by the pipeline processing
     */
    public void processException(final Message message, final Throwable th)
    {
    }
    
    /**
     * Process a successful pipeline process. 
     * Invoked when the pipeline processing completes successfully.
     * 
     * @param message The original message.
     */
    public void processSuccess(final Message message)
    {
    }
}
