package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.InputStream;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;


/**
 * Test class FtpFileCache
 * 
 * @author Daniel Bevenius
 * @author Tom Cunningham
 *
 */
public class FtpFileCacheIntegrationTest
{
	private static Logger log = Logger.getLogger(FtpFileCacheIntegrationTest.class);
	
	private static FtpFileCache ftpfileCache;

	@Test
	public void getConfigInputStream_From_Classpath() throws Exception
	{
		String configPath_CP = "/org/jboss/soa/esb/listeners/gateway/remotestrategies/cache/ftpfile_cache_test.xml";
		InputStream configInputStream = ftpfileCache.getConfigInputStream( configPath_CP );
		assertNotNull( "InputStream was null", configInputStream );
	}
	
	@Test 
	public void getPutAndRemove()
	{
		String fileName = "testfile1";
		try
		{
			ftpfileCache.putFileName( fileName );
			
			Object obj = ftpfileCache.getFileName( fileName );
			assertTrue( obj instanceof String );
			
			String actualFileName = (String) obj;
			assertEquals( fileName, actualFileName );
		}
		catch (CacheException e)
		{
			fail ( e.getMessage() );
		}
		finally
		{
			try { ftpfileCache.deleteFile( fileName ); } catch (CacheException e) { log.error( e.getMessage() ); }
		}
	}
	
	@Test 
	public void addCacheListenerNegative()
	{
		try
		{
			ftpfileCache.addCacheListener( null );
		}
		catch ( Exception e )
		{
			fail("Should be ok to pass a null listener! Exception was : "+ e.getMessage() ); 
		}
	}
	
	@Test
	public void fileExists() throws CacheException
	{
		String fileName = "testfile1";
		
		ftpfileCache.putFileName( fileName );
	
		boolean fileExistsInCache =  ftpfileCache.containsFile( fileName );
		assertTrue ( fileExistsInCache );
	}
	
	@Test
	public void removeAll() throws CacheException 
	{
		String fileName = "testfile3";
		ftpfileCache.putFileName( fileName );
		ftpfileCache.removeAll();
		assertNull ( ftpfileCache.getFileName( fileName ));		
	}
	
	@BeforeClass
	public static void classSetup() throws Exception
	{
		FtpFileCacheTestUtil.startDB();
		
		ftpfileCache = new FtpFileCache ( FtpFileCacheTestUtil.getCacheConfigFile() );
		ftpfileCache.start();
	}
	
	
	@AfterClass
	public static void classTearDown() throws Exception 
	{
		ftpfileCache.stop();
		FtpFileCacheTestUtil.stopDB();
	}
	
	public static junit.framework.Test suite() 
	{
		return new JUnit4TestAdapter( FtpFileCacheIntegrationTest.class );
	}
	
}
