/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.parameters;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.parameters.ParamFileRepository;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;

/**
 * ParamRepositoryFactory unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ParamRepositoryFactoryUnitTest extends TestCase {

	public void test_ParamRepositoryFactory() {
		ParamRepository repo;
		
		repo = ParamRepositoryFactory.getInstance();
		assertTrue(repo instanceof ParamFileRepository);
		
		ParamRepositoryFactory.reset();
		ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE).setProperty(Environment.PARAMS_REPOS_IMPL_CLASS, TestParamRepo.class.getName());
		repo = ParamRepositoryFactory.getInstance();
		assertTrue(repo instanceof TestParamRepo);
	}
	
	public void test_ParamRepositoryException() {
		// for the coverage results ;-)
		new ParamRepositoryException("message");
		new ParamRepositoryException("message", new Exception());
	}
}
