package org.jboss.soa.esb.services.jbpm5;

import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import org.jboss.soa.esb.services.jbpm5.actions.BpmParameterMapper;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import org.junit.Test;
import org.junit.BeforeClass;
import org.apache.log4j.Logger;


/**
 * Test the BPMParameterMapper.
 *  
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.11
 */
public class Bpm5ParameterMapperUnitTest {
    private ConfigTree config = null;
	
    private static final Logger logger = Logger.getLogger(Bpm5ParameterMapperUnitTest.class);
    
	@BeforeClass
    public static void setup()
    {
        logger.info("Setting up jBPM");
    }

    @Test
	public void testNoValues() throws Exception
	{
    	ConfigTree configNoValue = new ConfigTree("<property name=\"esbToBpmParams\"/>");
    	Message message = MessageFactory.getInstance().getMessage() ;
    	message.getProperties().setProperty("employee", "joe");
    	message.getProperties().setProperty("reason", "theheckofit");
    	Map<String, Object> map = BpmParameterMapper.mapPropertiesToParams(message, configNoValue);
    	assertEquals(map.size(), 0);
	}
    
    @Test
	public void testEsbToBpm() throws Exception
	{
        config = ConfigTree.fromXml("<property name=\"esbToBpmParams\">"
        		+ "<mapping esb=\"employee\" bpm=\"employee\"/>"
                + "<mapping esb=\"reason\" bpm=\"reason\"/>"
                + "</property>");

    	Message message = MessageFactory.getInstance().getMessage() ;
    	message.getProperties().setProperty("employee", "joe");
    	message.getProperties().setProperty("reason", "theheckofit");
    	Map<String, Object> map = BpmParameterMapper.mapPropertiesToParams(message, config);
    	String employee = (String)map.get("employee");
    	String reason = (String)map.get("reason");
    	assertEquals(employee, "joe");
    	assertEquals(reason, "theheckofit");    	
	}
        
    @Test
	public void testValue() throws Exception
	{
        config = ConfigTree.fromXml("<property name=\"esbToBpmParams\">"
        		+ "<mapping esb=\"employee\" bpm=\"employee\" value=\"krisv\"/>"
                + "<mapping esb=\"reason\" bpm=\"reason\" value=\"foobar\"/>"
        		+ "</property>");
        
        
    	Message message = MessageFactory.getInstance().getMessage() ;
    	message.getProperties().setProperty("employee", "joe");
    	message.getProperties().setProperty("reason", "theheckofit");
    	Map<String, Object> map = BpmParameterMapper.mapPropertiesToParams(message, config);
    	String employee = (String)map.get("employee");
    	String reason = (String)map.get("reason");
    	assertEquals(employee, "krisv");
    	assertEquals(reason, "foobar");
	}
}
