#!/bin/sh
#
# Run Riftsaw Integration tests.

MAVEN_OPTS="-Xms512M -Xmx1024M"

RIFTSAW_PARENT_DIR="$WORKSPACE"
DOWNLOAD_DIR="$RIFTSAW_PARENT_DIR/downloads"


DATABASE="hsql"

RIFTSAW_VERSION="2.3.6.Final"
AS_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jboss-soa-p.5.0.0/jboss-as"
AS_CONFIG="default"
REPLACE_QA_JDBC="true"
AS_VERSION="5"

JBOSS_ESB_VERSION="4.10"
JBOSS_ESB_HOME="$RIFTSAW_PARENT_DIR/riftsaw-$RIFTSAW_VERSION/jbossesb-$JBOSS_ESB_VERSION"

WS_VERSION="3.1.2.GA"
WS_STACK="native"
WS_STACK_DIR="$RIFTSAW_PARENT_DIR/downloads"

STARTUP_TIME="6"
TEST_DELAY="40000"

ANT_PROPERTIES="-Driftsaw.parent.dir=$RIFTSAW_PARENT_DIR -Ddatabase=$DATABASE -Dreplace.qa.jdbc=$REPLACE_QA_JDBC -Dorg.jboss.as.home=$AS_HOME -Dorg.jboss.as.config=$AS_CONFIG -Djbossesb.version=$JBOSS_ESB_VERSION -Dorg.jboss.esb.home=$JBOSS_ESB_HOME -Dws.stack=$WS_STACK -Dws.version=$WS_VERSION -Dws.stack.dir=$WS_STACK_DIR -Dstartup.time=$STARTUP_TIME -Ddownload.dir=$DOWNLOAD_DIR -Dtest.delay=$TEST_DELAY -Das.version=$AS_VERSION"
echo ANT_PROPERTIES=${ANT_PROPERTIES}

#build RiftSaw and running unit tests
cd ..
mvn clean install -Pdocs -Dmaven.repo.local=${WORKSPACE}/m2-repo

#cleanup the RiftSaw HOME
cd qa
ant $ANT_PROPERTIES stop-server
ant $ANT_PROPERTIES clean
ant $ANT_PROPERTIES install.soa-p

# clean up the database
#ant $ANT_PROPERTIES drop.riftsaw.schema

#build the RiftSaw and run integration tests
cd ../integration-tests 
mvn $ANT_PROPERTIES clean install -Dmaven.repo.local=${WORKSPACE}/m2-repo
