/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.epr;

import javax.management.ObjectName;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.server.EPRStorageMBean;
import org.jboss.soa.esb.server.EPRStorage;


public class StoreToJMXAction extends AbstractActionPipelineProcessor
{
   protected ConfigTree _config;

   public StoreToJMXAction(ConfigTree config)
   {
      _config = config;
   }

   public Message noOperation(Message message)
   {
      return message;
   }

   public Message process(Message message) throws ActionProcessingException
   {
      logHeader();
      System.out.println("Body: " + message.getBody().get());
      logFooter();
      MBeanServer server = MBeanServerLocator.locateJBoss();
      try
      {
	  ObjectName on = new ObjectName(EPRStorageMBean.objectName);
	  String value = (String) message.getBody().get();
	  Attribute attribute = new Attribute("Message", value); 	
	  server.setAttribute(on, attribute);
	  System.out.println((String)message.getBody().get());
      }
      catch (final MalformedObjectNameException mone)
      {
          throw new ActionProcessingException("Error creating MBean proxy", mone) ;
      } catch (InstanceNotFoundException infe) 
      {
	  throw new ActionProcessingException("Instance not found", infe);
      } catch (AttributeNotFoundException anfe)
      {
	  throw new ActionProcessingException("Message attribute not found", anfe);
      } catch (Exception e) {
     	  throw new ActionProcessingException("Exception caught", e); 
      }
      return message;
   }

   // This makes it easier to read on the console
   private void logHeader()
   {
      System.out.println("\n&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
   }

   private void logFooter()
   {
      System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\n");
   }


}
