/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstarts.bpm_orchestration3.test.SendJMSMessage;

/**
 * CI test for the bpmorchestration3 test.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class BPMOrchestration3Test extends AbstractQuickstartTestCase {
	private static final String DEPLOY_MESSAGE = "Hello Deploy";
	private static final String START_MESSAGE = "Hello start";
    private static final String SERVICE_1_MESSAGE = START_MESSAGE + " 'Service 1' ";
    private static final String SERVICE_2_MESSAGE = SERVICE_1_MESSAGE + " 'Service 2' ";
    private static final String SERVICE_3_MESSAGE = SERVICE_2_MESSAGE + " 'Service 3' ";
	
	public BPMOrchestration3Test(String name) {
		super(name);
	}
	
	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendDeployMessage() ;
	    checkMessages(30000, DEPLOY_MESSAGE, "Success:" + DEPLOY_MESSAGE) ;
	    
	    clearMessages() ;
	    sendStartMessage() ;
	    checkMessages(30000, START_MESSAGE, SERVICE_1_MESSAGE,
	        SERVICE_2_MESSAGE, SERVICE_3_MESSAGE) ;
	}

	public void sendDeployMessage() throws Exception {
		SendJMSMessage sdm = new SendJMSMessage();
		sdm.setupConnection("queue/quickstart_bpm_orchestration3_deploy_Request_gw");
		sdm.sendAMessage("Hello Deploy", null);
		sdm.stop();
	}
	
    public void sendStartMessage() throws Exception {
		SendJMSMessage ssm = new SendJMSMessage();
		ssm.setupConnection("queue/quickstart_bpm_orchestration3_start_Request_gw");
		ssm.sendAMessage("Hello start", "${token}");
		ssm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(BPMOrchestration3Test.class, "QuickstartMessageStoreServer.sar, Quickstart_bpm_orchestration3.esb");
	}
}
