/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.soa.bpel.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.apache.ode.bpel.iapi.Cache;
import org.jboss.cache.Fqn;

/**
 * JBossCache implementation of {@Cache} API.
 * 
 * @author jeffyu
 *
 */
public class JBossCache<K, V> implements Cache<K, V> {
	
	private final org.jboss.cache.Cache<K, V> cache;
	
	private final Fqn<String> fqn;
	
	public JBossCache(org.jboss.cache.Cache<K, V> cache, Fqn<String> fqn) {
		this.cache = cache;
		this.fqn = fqn;		
	}

	public boolean containsKey(K key) {		
		if (cache.getData(fqn) == null || cache.getData(fqn).size() < 1) {
			return false;
		}
		return cache.getData(fqn).containsKey(key);
	}

	public V get(K key) {
		return cache.get(fqn, key);
	}

	public Set<K> keySet() {
		Set<K> keyset = cache.getKeys(fqn);
		if (keyset == null) {
			keyset = new HashSet<K>();
		}
		return keyset;
	}

	public V put(K key, V value) {
		return cache.put(fqn, key, value);
	}

	public V remove(K key) {
		return cache.remove(fqn, key);
	}

	public Collection<V> values() {
		return cache.getData(fqn).values();
	}

}
