/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;

import org.jboss.soa.bpel.runtime.engine.BPELEngine;
import org.jboss.soa.dsp.ServiceProvider;
import org.jboss.soa.dsp.ws.SOAPMessageAdapter;
import org.jboss.soa.dsp.ws.WSInvocationAdapter;
import org.jboss.soa.dsp.ws.WebServiceProviderFactory;

public class ODEWebServiceFactory implements WebServiceProviderFactory {

	public ServiceProvider getServiceProvider() {
		return(getEngine());
	}

	public WSInvocationAdapter getInvocationAdapter(String operationName,
			QName serviceName, String portName, SOAPMessageAdapter soapAdapter) {
		return(new WSInvocationAdapter(operationName,
					serviceName, portName, soapAdapter));
	}

	private BPELEngine getEngine() {
		try {
			InitialContext ctx = new InitialContext();
			return (BPELEngine)ctx.lookup("bpel/Engine");
		} catch (NamingException e) {
			throw new RuntimeException("Failed to initialize BPEL engine");
		}
	}
}
