/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.AbstractMemoryIO;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.NativeRuntime;

class DirectMemoryIO
extends AbstractMemoryIO {
    static final MemoryIO IO = MemoryIO.getInstance();
    protected final long address;

    DirectMemoryIO(Runtime runtime, long address2) {
        super(runtime);
        this.address = address2;
    }

    DirectMemoryIO(Runtime runtime, int address2) {
        super(runtime);
        this.address = (long)address2 & 0xFFFFFFFFL;
    }

    DirectMemoryIO(long address2) {
        this((Runtime)NativeRuntime.getInstance(), address2);
    }

    DirectMemoryIO(int address2) {
        this((Runtime)NativeRuntime.getInstance(), address2);
    }

    public final long address() {
        return this.address;
    }

    public long size() {
        return Long.MAX_VALUE;
    }

    public boolean hasArray() {
        return false;
    }

    public Object array() {
        return null;
    }

    public int arrayOffset() {
        return 0;
    }

    public int arrayLength() {
        return 0;
    }

    public String toString() {
        return String.format(this.getClass().getName() + "[address=%x]", this.address);
    }

    public int hashCode() {
        return (int)(this.address << 32 ^ this.address);
    }

    public boolean equals(Object obj) {
        return obj instanceof Pointer && ((Pointer)obj).address() == this.address && ((Pointer)obj).getRuntime().equals(this.getRuntime());
    }

    public final byte getByte(long offset2) {
        return IO.getByte(this.address + offset2);
    }

    public final short getShort(long offset2) {
        return IO.getShort(this.address + offset2);
    }

    public final int getInt(long offset2) {
        return IO.getInt(this.address + offset2);
    }

    public final long getLongLong(long offset2) {
        return IO.getLong(this.address + offset2);
    }

    public final float getFloat(long offset2) {
        return IO.getFloat(this.address + offset2);
    }

    public final double getDouble(long offset2) {
        return IO.getDouble(this.address + offset2);
    }

    public final void putByte(long offset2, byte value2) {
        IO.putByte(this.address + offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        IO.putShort(this.address + offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        IO.putInt(this.address + offset2, value2);
    }

    public final void putLongLong(long offset2, long value2) {
        IO.putLong(this.address + offset2, value2);
    }

    public final void putFloat(long offset2, float value2) {
        IO.putFloat(this.address + offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        IO.putDouble(this.address + offset2, value2);
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        IO.getByteArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        IO.putByteArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        IO.getShortArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, short[] src, int off, int len) {
        IO.putShortArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        IO.getIntArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, int[] src, int off, int len) {
        IO.putIntArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        IO.getLongArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, long[] src, int off, int len) {
        IO.putLongArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        IO.getFloatArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, float[] src, int off, int len) {
        IO.putFloatArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        IO.getDoubleArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, double[] src, int off, int len) {
        IO.putDoubleArray(this.address + offset2, src, off, len);
    }

    public Pointer getPointer(long offset2) {
        return MemoryUtil.newPointer(IO.getAddress(this.address + offset2));
    }

    public Pointer getPointer(long offset2, long size2) {
        return MemoryUtil.newPointer(IO.getAddress(this.address + offset2), size2);
    }

    public void putPointer(long offset2, Pointer value2) {
        IO.putAddress(this.address + offset2, value2 != null ? value2.address() : 0L);
    }

    public String getString(long offset2) {
        return Charset.defaultCharset().decode(ByteBuffer.wrap(IO.getZeroTerminatedByteArray(this.address + offset2))).toString();
    }

    public String getString(long offset2, int maxLength, Charset cs) {
        byte[] bytes2 = IO.getZeroTerminatedByteArray(this.address + offset2, maxLength);
        return Charset.defaultCharset().decode(ByteBuffer.wrap(bytes2)).toString();
    }

    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        ByteBuffer buf = cs.encode(string2);
        int len = Math.min(maxLength, buf.remaining());
        IO.putZeroTerminatedByteArray(this.address + offset2, buf.array(), buf.arrayOffset() + buf.position(), len);
    }

    public void putZeroTerminatedByteArray(long offset2, byte[] src, int off, int len) {
        IO.putZeroTerminatedByteArray(this.address + offset2, src, off, len);
    }

    public int indexOf(long offset2, byte value2, int maxlen) {
        return (int)IO.indexOf(this.address + offset2, value2, maxlen);
    }

    public final boolean isDirect() {
        return true;
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        IO.setMemory(this.address + offset2, size2, value2);
    }
}

