/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.internal.runtime.methods.CacheableMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.DynamicMethodFactory;
import org.jruby.internal.runtime.methods.InterpretedMethod;
import org.jruby.internal.runtime.methods.JittedMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultMethod
extends DynamicMethod
implements MethodArgs,
PositionAware,
CacheableMethod {
    private DynamicMethodBox box = new DynamicMethodBox();
    private final StaticScope staticScope;
    private final Node body;
    private final ArgsNode argsNode;
    private final ISourcePosition position;
    private final InterpretedMethod interpretedMethod;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, String name2, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull, name2);
        this.interpretedMethod = DynamicMethodFactory.newInterpretedMethod(implementationClass.getRuntime(), implementationClass, staticScope, body, name2, argsNode, visibility, position);
        this.interpretedMethod.serialNumber = this.serialNumber;
        this.box.actualMethod = this.interpretedMethod;
        this.argsNode = argsNode;
        this.body = body;
        this.staticScope = staticScope;
        this.position = position;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.box.callCount;
    }

    public int incrementCallCount() {
        return ++this.box.callCount;
    }

    public void setCallCount(int callCount) {
        this.box.callCount = callCount;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public DynamicMethod getMethodForCaching() {
        DynamicMethod method2 = this.box.actualMethod;
        if (method2 instanceof JittedMethod) {
            return method2;
        }
        return this;
    }

    public void switchToJitted(Script jitCompiledScript, CallConfiguration jitCallConfig) {
        this.box.actualMethod = DynamicMethodFactory.newJittedMethod(this.getImplementationClass().getRuntime(), this.getImplementationClass(), this.staticScope, jitCompiledScript, this.name, jitCallConfig, this.getVisibility(), this.argsNode.getArity(), this.position, this);
        this.box.actualMethod.serialNumber = this.serialNumber;
        this.box.callCount = -1;
        this.getImplementationClass().invalidateCacheDescendants();
    }

    private DynamicMethod tryJitReturnMethod(ThreadContext context) {
        MetaClass metaClass;
        RubyClass realClass;
        String className = this.implementationClass.isSingleton() ? ((realClass = (metaClass = (MetaClass)this.implementationClass).getRealClass()) == context.runtime.getClassClass() ? ((RubyClass)metaClass.getAttached()).getName() : realClass.getName()) : this.implementationClass.getName();
        className.replaceAll("::", ".");
        context.runtime.getJITCompiler().tryJIT(this, context, className, this.name);
        return this.box.actualMethod;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, args2, block);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, args2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, args2);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, args2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2);
        }
        return this.box.actualMethod.call(context, self, clazz, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, block);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0, block);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0, arg1);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0, arg1, block);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0, arg1, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0, arg1, arg2);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.box.callCount >= 0) {
            return this.tryJitReturnMethod(context).call(context, self, clazz, name2, arg0, arg1, arg2, block);
        }
        return this.box.actualMethod.call(context, self, clazz, name2, arg0, arg1, arg2, block);
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        DefaultMethod newMethod = new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.name, this.argsNode, this.getVisibility(), this.position);
        newMethod.setIsBuiltin(this.builtin);
        newMethod.box = this.box;
        return newMethod;
    }

    public void setVisibility(Visibility visibility) {
        DynamicMethodBox newBox = new DynamicMethodBox();
        newBox.actualMethod = this.box.actualMethod.dup();
        newBox.callCount = this.box.callCount;
        this.box = newBox;
        super.setVisibility(visibility);
    }

    private static class DynamicMethodBox {
        public DynamicMethod actualMethod;
        public int callCount = 0;

        private DynamicMethodBox() {
        }
    }
}

