/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby19;

import org.jcodings.Encoding;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class GetEncodingInstr
extends Instr
implements ResultInstr {
    private final Encoding encoding;
    private Variable result;

    public GetEncodingInstr(Variable result2, Encoding encoding2) {
        super(Operation.GET_ENCODING);
        this.result = result2;
        this.encoding = encoding2;
    }

    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    public String toString() {
        return super.toString() + "(" + this.encoding + ")";
    }

    public Variable getResult() {
        return this.result;
    }

    public void updateResult(Variable v) {
        this.result = v;
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new GetEncodingInstr(ii.getRenamedVariable(this.result), this.encoding);
    }

    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        return context.runtime.getEncodingService().getEncoding(this.encoding);
    }

    public void visit(IRVisitor visitor) {
        visitor.GetEncodingInstr(this);
    }
}

