/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.nist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.sec.SECNamedCurves;
import org.jruby.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x9.X9ECParameters;
import org.jruby.org.bouncycastle.util.Strings;

public class NISTNamedCurves {
    static final Hashtable objIds = new Hashtable();
    static final Hashtable names = new Hashtable();

    static void defineCurve(String string2, DERObjectIdentifier dERObjectIdentifier) {
        objIds.put(string2, dERObjectIdentifier);
        names.put(dERObjectIdentifier, string2);
    }

    public static X9ECParameters getByName(String string2) {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)objIds.get(Strings.toUpperCase(string2));
        if (dERObjectIdentifier != null) {
            return NISTNamedCurves.getByOID(dERObjectIdentifier);
        }
        return null;
    }

    public static X9ECParameters getByOID(DERObjectIdentifier dERObjectIdentifier) {
        return SECNamedCurves.getByOID(dERObjectIdentifier);
    }

    public static DERObjectIdentifier getOID(String string2) {
        return (DERObjectIdentifier)objIds.get(Strings.toUpperCase(string2));
    }

    public static String getName(DERObjectIdentifier dERObjectIdentifier) {
        return (String)names.get(dERObjectIdentifier);
    }

    public static Enumeration getNames() {
        return objIds.keys();
    }

    static {
        NISTNamedCurves.defineCurve("B-571", SECObjectIdentifiers.sect571r1);
        NISTNamedCurves.defineCurve("B-409", SECObjectIdentifiers.sect409r1);
        NISTNamedCurves.defineCurve("B-283", SECObjectIdentifiers.sect283r1);
        NISTNamedCurves.defineCurve("B-233", SECObjectIdentifiers.sect233r1);
        NISTNamedCurves.defineCurve("B-163", SECObjectIdentifiers.sect163r2);
        NISTNamedCurves.defineCurve("P-521", SECObjectIdentifiers.secp521r1);
        NISTNamedCurves.defineCurve("P-384", SECObjectIdentifiers.secp384r1);
        NISTNamedCurves.defineCurve("P-256", SECObjectIdentifiers.secp256r1);
        NISTNamedCurves.defineCurve("P-224", SECObjectIdentifiers.secp224r1);
        NISTNamedCurves.defineCurve("P-192", SECObjectIdentifiers.secp192r1);
    }
}

