/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.BERApplicationSpecific;
import org.jruby.org.bouncycastle.asn1.BERConstructedOctetString;
import org.jruby.org.bouncycastle.asn1.BERSequence;
import org.jruby.org.bouncycastle.asn1.BERSet;
import org.jruby.org.bouncycastle.asn1.BERTaggedObject;
import org.jruby.org.bouncycastle.asn1.DERApplicationSpecific;
import org.jruby.org.bouncycastle.asn1.DERBMPString;
import org.jruby.org.bouncycastle.asn1.DERBitString;
import org.jruby.org.bouncycastle.asn1.DERBoolean;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DEREnumerated;
import org.jruby.org.bouncycastle.asn1.DERExternal;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.DERIA5String;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERPrintableString;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERT61String;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.DERUTCTime;
import org.jruby.org.bouncycastle.asn1.DERUTF8String;
import org.jruby.org.bouncycastle.asn1.DERUnknownTag;
import org.jruby.org.bouncycastle.asn1.DERVisibleString;
import org.jruby.org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string2, boolean bl, DERObject dERObject, StringBuffer stringBuffer) {
        String string3 = System.getProperty("line.separator");
        if (dERObject instanceof ASN1Sequence) {
            Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
            String string4 = string2 + TAB;
            stringBuffer.append(string2);
            if (dERObject instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (dERObject instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string4);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string4, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string4, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERTaggedObject) {
            String string5 = string2 + TAB;
            stringBuffer.append(string2);
            if (dERObject instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append(']');
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string3);
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string5);
                stringBuffer.append("EMPTY");
                stringBuffer.append(string3);
            } else {
                ASN1Dump._dumpAsString(string5, bl, dERTaggedObject.getObject(), stringBuffer);
            }
        } else if (dERObject instanceof BERSet) {
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = string2 + TAB;
            stringBuffer.append(string2);
            stringBuffer.append("BER Set");
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string6, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string6, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERSet) {
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string7 = string2 + TAB;
            stringBuffer.append(string2);
            stringBuffer.append("DER Set");
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string7);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof DERObject) {
                    ASN1Dump._dumpAsString(string7, bl, (DERObject)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string7, bl, ((DEREncodable)e).getDERObject(), stringBuffer);
            }
        } else if (dERObject instanceof DERObjectIdentifier) {
            stringBuffer.append(string2 + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + string3);
        } else if (dERObject instanceof DERBoolean) {
            stringBuffer.append(string2 + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + string3);
        } else if (dERObject instanceof DERInteger) {
            stringBuffer.append(string2 + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + string3);
        } else if (dERObject instanceof BERConstructedOctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            stringBuffer.append(string2 + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (dERObject instanceof DEROctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
            stringBuffer.append(string2 + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (dERObject instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)dERObject;
            stringBuffer.append(string2 + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, dERBitString.getBytes()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (dERObject instanceof DERIA5String) {
            stringBuffer.append(string2 + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERUTF8String) {
            stringBuffer.append(string2 + "UTF8String(" + ((DERUTF8String)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERPrintableString) {
            stringBuffer.append(string2 + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERVisibleString) {
            stringBuffer.append(string2 + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERBMPString) {
            stringBuffer.append(string2 + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERT61String) {
            stringBuffer.append(string2 + "T61String(" + ((DERT61String)dERObject).getString() + ") " + string3);
        } else if (dERObject instanceof DERUTCTime) {
            stringBuffer.append(string2 + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + string3);
        } else if (dERObject instanceof DERGeneralizedTime) {
            stringBuffer.append(string2 + "GeneralizedTime(" + ((DERGeneralizedTime)dERObject).getTime() + ") " + string3);
        } else if (dERObject instanceof DERUnknownTag) {
            stringBuffer.append(string2 + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + string3);
        } else if (dERObject instanceof BERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("BER", string2, bl, dERObject, string3));
        } else if (dERObject instanceof DERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("DER", string2, bl, dERObject, string3));
        } else if (dERObject instanceof DEREnumerated) {
            DEREnumerated dEREnumerated = (DEREnumerated)dERObject;
            stringBuffer.append(string2 + "DER Enumerated(" + dEREnumerated.getValue() + ")" + string3);
        } else if (dERObject instanceof DERExternal) {
            DERExternal dERExternal = (DERExternal)dERObject;
            stringBuffer.append(string2 + "External " + string3);
            String string8 = string2 + TAB;
            if (dERExternal.getDirectReference() != null) {
                stringBuffer.append(string8 + "Direct Reference: " + dERExternal.getDirectReference().getId() + string3);
            }
            if (dERExternal.getIndirectReference() != null) {
                stringBuffer.append(string8 + "Indirect Reference: " + dERExternal.getIndirectReference().toString() + string3);
            }
            if (dERExternal.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string8, bl, dERExternal.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string8 + "Encoding: " + dERExternal.getEncoding() + string3);
            ASN1Dump._dumpAsString(string8, bl, dERExternal.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(string2 + dERObject.toString() + string3);
        }
    }

    private static String outputApplicationSpecific(String string2, String string3, boolean bl, DERObject dERObject, String string4) {
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        StringBuffer stringBuffer = new StringBuffer();
        if (dERApplicationSpecific.isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(dERApplicationSpecific.getObject(16));
                stringBuffer.append(string3 + string2 + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "]" + string4);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Dump._dumpAsString(string3 + TAB, bl, (DERObject)enumeration.nextElement(), stringBuffer);
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string3 + string2 + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "] (" + new String(Hex.encode(dERApplicationSpecific.getContents())) + ")" + string4;
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof DERObject) {
            ASN1Dump._dumpAsString("", bl, (DERObject)object, stringBuffer);
        } else if (object instanceof DEREncodable) {
            ASN1Dump._dumpAsString("", bl, ((DEREncodable)object).getDERObject(), stringBuffer);
        } else {
            return "unknown object type " + object.toString();
        }
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string2, byte[] byArray) {
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string2 + TAB;
        stringBuffer.append(string3);
        for (int j = 0; j < byArray.length; j += 32) {
            if (byArray.length - j > 32) {
                stringBuffer.append(string2);
                stringBuffer.append(new String(Hex.encode(byArray, j, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, j, 32));
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(new String(Hex.encode(byArray, j, byArray.length - j)));
            for (int k = byArray.length - j; k != 32; ++k) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, j, byArray.length - j));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = n; j != n + n2; ++j) {
            if (byArray[j] < 32 || byArray[j] > 126) continue;
            stringBuffer.append((char)byArray[j]);
        }
        return stringBuffer.toString();
    }
}

