/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.x509.GeneralName;

public class AccessDescription
extends ASN1Encodable {
    public static final DERObjectIdentifier id_ad_caIssuers = new DERObjectIdentifier("1.3.6.1.5.5.7.48.2");
    public static final DERObjectIdentifier id_ad_ocsp = new DERObjectIdentifier("1.3.6.1.5.5.7.48.1");
    DERObjectIdentifier accessMethod = null;
    GeneralName accessLocation = null;

    public static AccessDescription getInstance(Object object) {
        if (object instanceof AccessDescription) {
            return (AccessDescription)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AccessDescription((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public AccessDescription(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("wrong number of elements in sequence");
        }
        this.accessMethod = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.accessLocation = GeneralName.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public AccessDescription(DERObjectIdentifier dERObjectIdentifier, GeneralName generalName) {
        this.accessMethod = dERObjectIdentifier;
        this.accessLocation = generalName;
    }

    public DERObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.accessMethod);
        aSN1EncodableVector.add(this.accessLocation);
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "AccessDescription: Oid(" + this.accessMethod.getId() + ")";
    }
}

