/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.BERGenerator;
import org.jruby.org.bouncycastle.asn1.BERSequenceGenerator;
import org.jruby.org.bouncycastle.asn1.BERSet;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.cms.AuthenticatedData;
import org.jruby.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.jruby.org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.MacOutputStream;
import org.jruby.org.bouncycastle.operator.DigestCalculator;
import org.jruby.org.bouncycastle.operator.GenericKey;
import org.jruby.org.bouncycastle.operator.MacCalculator;
import org.jruby.org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public CMSAuthenticatedDataStreamGenerator() {
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this.berEncodeRecipientSet = bl;
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator);
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(aSN1ObjectIdentifier, outputStream, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            Object object2;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (Object object2 : this.recipientInfoGenerators) {
                aSN1EncodableVector.add(object2.generate(macCalculator.getKey()));
            }
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.authenticatedData);
            object2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            ((BERSequenceGenerator)object2).addObject(new DERInteger(AuthenticatedData.calculateVersion(null)));
            if (this.berEncodeRecipientSet) {
                ((BERGenerator)object2).getRawOutputStream().write(new BERSet(aSN1EncodableVector).getEncoded());
            } else {
                ((BERGenerator)object2).getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
            }
            AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
            ((BERGenerator)object2).getRawOutputStream().write(algorithmIdentifier.getEncoded());
            if (digestCalculator != null) {
                ((BERSequenceGenerator)object2).addObject(new DERTaggedObject(false, 1, digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(((BERGenerator)object2).getRawOutputStream());
            bERSequenceGenerator2.addObject(aSN1ObjectIdentifier);
            OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator2.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream teeOutputStream = digestCalculator != null ? new TeeOutputStream(outputStream2, digestCalculator.getOutputStream()) : new TeeOutputStream(outputStream2, macCalculator.getOutputStream());
            return new CmsAuthenticatedDataOutputStream(macCalculator, digestCalculator, aSN1ObjectIdentifier, teeOutputStream, bERSequenceGenerator, (BERSequenceGenerator)object2, bERSequenceGenerator2);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public CMSAuthenticatedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private OutputStream open(OutputStream outputStream, String string2, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider provider2 = keyGenerator.getProvider();
        SecretKey secretKey = keyGenerator.generateKey();
        AlgorithmParameterSpec algorithmParameterSpec = this.generateParameterSpec(string2, secretKey, provider2);
        Iterator iterator = this.oldRecipientInfoGenerators.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            Object object = (IntRecipientInfoGenerator)iterator.next();
            try {
                aSN1EncodableVector.add(object.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        for (Object object : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(object.generate(new GenericKey(secretKey)));
        }
        return this.open(outputStream, string2, secretKey, algorithmParameterSpec, aSN1EncodableVector, provider2);
    }

    protected OutputStream open(OutputStream outputStream, String string2, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec, ASN1EncodableVector aSN1EncodableVector, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.open(outputStream, string2, secretKey, algorithmParameterSpec, aSN1EncodableVector, CMSUtils.getProvider(string3));
    }

    protected OutputStream open(OutputStream outputStream, String string2, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec, ASN1EncodableVector aSN1EncodableVector, Provider provider) throws NoSuchAlgorithmException, CMSException {
        try {
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            bERSequenceGenerator2.addObject(new DERInteger(AuthenticatedData.calculateVersion(null)));
            if (this.berEncodeRecipientSet) {
                bERSequenceGenerator2.getRawOutputStream().write(new BERSet(aSN1EncodableVector).getEncoded());
            } else {
                bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
            }
            Mac mac = CMSEnvelopedHelper.INSTANCE.getMac(string2, provider);
            mac.init(secretKey, algorithmParameterSpec);
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(string2, algorithmParameterSpec, provider);
            bERSequenceGenerator2.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject(CMSObjectIdentifiers.data);
            OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream teeOutputStream = new TeeOutputStream(outputStream2, new MacOutputStream(mac));
            return new OldCmsAuthenticatedDataOutputStream(teeOutputStream, mac, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameter invalid.", invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("algorithm parameter spec invalid.", invalidParameterSpecException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public OutputStream open(OutputStream outputStream, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string2, CMSUtils.getProvider(string3));
    }

    public OutputStream open(OutputStream outputStream, String string2, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string2, provider);
        keyGenerator.init(this.rand);
        return this.open(outputStream, string2, keyGenerator, provider);
    }

    public OutputStream open(OutputStream outputStream, String string2, int n, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string2, n, CMSUtils.getProvider(string3));
    }

    public OutputStream open(OutputStream outputStream, String string2, int n, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string2, provider);
        keyGenerator.init(n, this.rand);
        return this.open(outputStream, string2, keyGenerator, provider);
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;
        private MacCalculator macCalculator;
        private DigestCalculator digestCalculator;
        private ASN1ObjectIdentifier contentType;

        public CmsAuthenticatedDataOutputStream(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.macCalculator = macCalculator;
            this.digestCalculator = digestCalculator;
            this.contentType = aSN1ObjectIdentifier;
            this.dataStream = outputStream;
            this.cGen = bERSequenceGenerator;
            this.envGen = bERSequenceGenerator2;
            this.eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this.dataStream.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dataStream.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dataStream.write(byArray);
        }

        public void close() throws IOException {
            Map map;
            this.dataStream.close();
            this.eiGen.close();
            if (this.digestCalculator != null) {
                map = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters(this.contentType, this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet dERSet = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(map).toASN1EncodableVector());
                OutputStream outputStream = this.macCalculator.getOutputStream();
                outputStream.write(dERSet.getDEREncoded());
                outputStream.close();
                this.envGen.addObject(new DERTaggedObject(false, 2, dERSet));
            } else {
                map = Collections.unmodifiableMap(new HashMap());
            }
            this.envGen.addObject(new DEROctetString(this.macCalculator.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.envGen.addObject(new DERTaggedObject(false, 3, new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(map).toASN1EncodableVector())));
            }
            this.envGen.close();
            this.cGen.close();
        }
    }

    private class OldCmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private Mac mac;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;

        public OldCmsAuthenticatedDataOutputStream(OutputStream outputStream, Mac mac, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.dataStream = outputStream;
            this.mac = mac;
            this.cGen = bERSequenceGenerator;
            this.envGen = bERSequenceGenerator2;
            this.eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this.dataStream.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dataStream.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dataStream.write(byArray);
        }

        public void close() throws IOException {
            this.dataStream.close();
            this.eiGen.close();
            this.envGen.addObject(new DEROctetString(this.mac.doFinal()));
            this.envGen.close();
            this.cGen.close();
        }
    }
}

