/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.jruby.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.jruby.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.jruby.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.jruby.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cms.AuthAttributesProvider;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSSecureReadable;
import org.jruby.org.bouncycastle.cms.CMSTypedStream;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.KeyAgreeRecipient;
import org.jruby.org.bouncycastle.cms.KeyAgreeRecipientId;
import org.jruby.org.bouncycastle.cms.OriginatorId;
import org.jruby.org.bouncycastle.cms.Recipient;
import org.jruby.org.bouncycastle.cms.RecipientId;
import org.jruby.org.bouncycastle.cms.RecipientInformation;
import org.jruby.org.bouncycastle.cms.RecipientOperator;
import org.jruby.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.jruby.org.bouncycastle.jce.spec.MQVPublicKeySpec;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List list2, KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ASN1Sequence aSN1Sequence = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
        for (int j = 0; j < aSN1Sequence.size(); ++j) {
            KeyAgreeRecipientId keyAgreeRecipientId;
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(j));
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber != null) {
                keyAgreeRecipientId = new KeyAgreeRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                keyAgreeRecipientId = new KeyAgreeRecipientId(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
            }
            list2.add(new KeyAgreeRecipientInformation(keyAgreeRecipientInfo, keyAgreeRecipientId, recipientEncryptedKey.getEncryptedKey(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, RecipientId recipientId, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyAgreeRecipientInfo;
        this.rid = recipientId;
        this.encryptedKey = aSN1OctetString;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, OriginatorIdentifierOrKey originatorIdentifierOrKey) throws CMSException, IOException {
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(algorithmIdentifier, originatorPublicKey);
        }
        OriginatorId originatorId = new OriginatorId();
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            originatorId.setIssuer(issuerAndSerialNumber.getName().getEncoded());
            originatorId.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            originatorId.setSubjectKeyIdentifier(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(originatorId);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, originatorPublicKey.getPublicKey().getBytes());
        return subjectPublicKeyInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId originatorId) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    private PublicKey getSenderPublicKey(Key key2, OriginatorIdentifierOrKey originatorIdentifierOrKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getSenderPublicKeyInfo(PrivateKeyInfo.getInstance(key2.getEncoded()).getAlgorithmId(), originatorIdentifierOrKey);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance(this.keyEncAlg.getAlgorithm().getId(), provider);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private PublicKey getPublicKeyFromOriginatorPublicKey(Key key2, OriginatorPublicKey originatorPublicKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getPublicKeyInfoFromOriginatorPublicKey(PrivateKeyInfo.getInstance(key2.getEncoded()).getAlgorithmId(), originatorPublicKey);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance(this.keyEncAlg.getAlgorithm().getId(), provider);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private SecretKey calculateAgreedWrapKey(String string2, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        Object object;
        String string3 = this.keyEncAlg.getAlgorithm().getId();
        if (string3.equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            object = this.info.getUserKeyingMaterial().getOctets();
            MQVuserKeyingMaterial mQVuserKeyingMaterial = MQVuserKeyingMaterial.getInstance(ASN1Object.fromByteArray((byte[])object));
            PublicKey publicKey2 = this.getPublicKeyFromOriginatorPublicKey(privateKey, mQVuserKeyingMaterial.getEphemeralPublicKey(), provider);
            publicKey = new MQVPublicKeySpec(publicKey, publicKey2);
            privateKey = new MQVPrivateKeySpec(privateKey, privateKey);
        }
        object = KeyAgreement.getInstance(string3, provider);
        ((KeyAgreement)object).init(privateKey);
        ((KeyAgreement)object).doPhase(publicKey, true);
        return ((KeyAgreement)object).generateSecret(string2);
    }

    private Key unwrapSessionKey(String string2, SecretKey secretKey, Provider provider) throws GeneralSecurityException {
        Cipher cipher2 = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(string2, provider);
        cipher2.init(4, secretKey);
        return cipher2.unwrap(this.encryptedKey.getOctets(), this.getContentAlgorithmName(), 3);
    }

    protected Key getSessionKey(Key key2, Provider provider) throws CMSException {
        try {
            String string2 = AlgorithmIdentifier.getInstance(this.keyEncAlg.getParameters()).getAlgorithm().getId();
            PublicKey publicKey = this.getSenderPublicKey(key2, this.info.getOriginator(), provider);
            SecretKey secretKey = this.calculateAgreedWrapKey(string2, publicKey, (PrivateKey)key2, provider);
            return this.unwrapSessionKey(string2, secretKey, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception2) {
            throw new CMSException("originator key invalid.", exception2);
        }
    }

    public CMSTypedStream getContentStream(Key key2, String string2) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key2, CMSUtils.getProvider(string2));
    }

    public CMSTypedStream getContentStream(Key key2, Provider provider) throws CMSException {
        Key key3 = this.getSessionKey(key2, provider);
        return this.getContentFromSessionKey(key3, provider);
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient keyAgreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = keyAgreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(algorithmIdentifier, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

