/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.jcajce;

import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.KEKRecipient;
import org.jruby.org.bouncycastle.cms.jcajce.CMSUtils;
import org.jruby.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.jruby.org.bouncycastle.operator.OperatorException;
import org.jruby.org.bouncycastle.operator.SymmetricKeyUnwrapper;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKEKRecipient(SecretKey secretKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
        this.recipientKey = secretKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String string2) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String string2) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        SymmetricKeyUnwrapper symmetricKeyUnwrapper = this.helper.createSymmetricUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getJceKey(symmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

