/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.crypto.tls;

import java.security.SecureRandom;
import org.jruby.org.bouncycastle.crypto.CryptoException;
import org.jruby.org.bouncycastle.crypto.DSA;
import org.jruby.org.bouncycastle.crypto.Signer;
import org.jruby.org.bouncycastle.crypto.digests.NullDigest;
import org.jruby.org.bouncycastle.crypto.digests.SHA1Digest;
import org.jruby.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.jruby.org.bouncycastle.crypto.params.ParametersWithRandom;
import org.jruby.org.bouncycastle.crypto.signers.DSADigestSigner;
import org.jruby.org.bouncycastle.crypto.tls.TlsSigner;

abstract class TlsDSASigner
implements TlsSigner {
    TlsDSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), new NullDigest());
        dSADigestSigner.init(true, new ParametersWithRandom(asymmetricKeyParameter, secureRandom));
        dSADigestSigner.update(byArray, 16, 20);
        return dSADigestSigner.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), new SHA1Digest());
        dSADigestSigner.init(false, asymmetricKeyParameter);
        return dSADigestSigner;
    }

    protected abstract DSA createDSAImpl();
}

