/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider.asymmetric.ec;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.jruby.org.bouncycastle.jce.provider.JCEECPublicKey;
import org.jruby.org.bouncycastle.jce.provider.JDKKeyFactory;
import org.jruby.org.bouncycastle.jce.provider.ProviderUtil;
import org.jruby.org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.jruby.org.bouncycastle.jce.spec.ECParameterSpec;
import org.jruby.org.bouncycastle.jce.spec.ECPublicKeySpec;

public class KeyFactory
extends JDKKeyFactory {
    String algorithm;

    KeyFactory(String string2) {
        this.algorithm = string2;
    }

    protected Key engineTranslateKey(Key key2) throws InvalidKeyException {
        if (key2 instanceof ECPublicKey) {
            return new JCEECPublicKey((ECPublicKey)key2);
        }
        if (key2 instanceof ECPrivateKey) {
            return new JCEECPrivateKey((ECPrivateKey)key2);
        }
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key2, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key2.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key2.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key2.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key2.getEncoded());
        }
        if (clazz.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key2 instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key2;
            if (eCPublicKey.getParams() != null) {
                return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            return new java.security.spec.ECPublicKeySpec(eCPublicKey.getW(), EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec));
        }
        if (clazz.isAssignableFrom(ECPrivateKeySpec.class) && key2 instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key2;
            if (eCPrivateKey.getParams() != null) {
                return new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            return new ECPrivateKeySpec(eCPrivateKey.getS(), EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec));
        }
        throw new RuntimeException("not implemented yet " + key2 + " " + clazz);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPrivateKey(this.algorithm, jCEECPrivateKey);
            }
            catch (Exception exception2) {
                throw new InvalidKeySpecException(exception2.toString());
            }
        }
        if (keySpec instanceof org.jruby.org.bouncycastle.jce.spec.ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (org.jruby.org.bouncycastle.jce.spec.ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPublicKey(this.algorithm, jCEECPublicKey);
            }
            catch (Exception exception2) {
                throw new InvalidKeySpecException(exception2.toString());
            }
        }
        if (keySpec instanceof ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    public static class EC
    extends KeyFactory {
        public EC() {
            super("EC");
        }
    }

    public static class ECDH
    extends KeyFactory {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDHC
    extends KeyFactory {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDSA
    extends KeyFactory {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class ECGOST3410
    extends KeyFactory {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECMQV
    extends KeyFactory {
        public ECMQV() {
            super("ECMQV");
        }
    }
}

