/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.jruby.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;
import org.jruby.org.bouncycastle.cms.CMSTypedStream;
import org.jruby.org.bouncycastle.jce.PrincipalUtil;
import org.jruby.org.bouncycastle.mail.smime.SMIMEException;
import org.jruby.org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.jruby.org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEUtil {
    private static final int BUF_SIZE = 32760;

    static boolean isCanonicalisationRequired(MimeBodyPart mimeBodyPart, String string2) throws MessagingException {
        String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
        String string3 = stringArray == null ? string2 : stringArray[0];
        return !string3.equalsIgnoreCase("binary");
    }

    public static Provider getProvider(String string2) throws NoSuchProviderException {
        if (string2 != null) {
            Provider provider = Security.getProvider(string2);
            if (provider != null) {
                return provider;
            }
            throw new NoSuchProviderException("provider " + string2 + " not found.");
        }
        return null;
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string2) throws MessagingException, IOException {
        String string3;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string3 = SMIMEUtil.readLine(inputStream)) != null && !string3.equals(string2)) {
            lineOutputStream.writeln(string3);
        }
        inputStream.close();
        if (string3 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    static void outputPostamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, int n, String string2) throws MessagingException, IOException {
        String string3;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        int n2 = n + 1;
        while (!((string3 = SMIMEUtil.readLine(inputStream)) == null || string3.startsWith(string2) && --n2 == 0)) {
        }
        while ((string3 = SMIMEUtil.readLine(inputStream)) != null) {
            lineOutputStream.writeln(string3);
        }
        inputStream.close();
        if (n2 != 0) {
            throw new MessagingException("all boundaries not found for: " + string2);
        }
    }

    static void outputPostamble(LineOutputStream lineOutputStream, BodyPart bodyPart, String string2, BodyPart bodyPart2) throws MessagingException, IOException {
        String string3;
        InputStream inputStream;
        try {
            inputStream = ((MimeBodyPart)bodyPart).getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        MimeMultipart mimeMultipart = (MimeMultipart)bodyPart2.getContent();
        ContentType contentType = new ContentType(mimeMultipart.getContentType());
        String string4 = "--" + contentType.getParameter("boundary");
        int n = mimeMultipart.getCount() + 1;
        while (n != 0 && (string3 = SMIMEUtil.readLine(inputStream)) != null) {
            if (!string3.startsWith(string4)) continue;
            --n;
        }
        while ((string3 = SMIMEUtil.readLine(inputStream)) != null && !string3.startsWith(string2)) {
            lineOutputStream.writeln(string3);
        }
        inputStream.close();
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    static void outputBodyPart(OutputStream outputStream, BodyPart bodyPart, String string2) throws MessagingException, IOException {
        if (bodyPart instanceof MimeBodyPart) {
            int n;
            Object object;
            InputStream inputStream;
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
            if (mimeBodyPart.getContent() instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)bodyPart.getContent();
                ContentType contentType = new ContentType(mimeMultipart.getContentType());
                String string3 = "--" + contentType.getParameter("boundary");
                LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    lineOutputStream.writeln(string4);
                }
                lineOutputStream.writeln();
                SMIMEUtil.outputPreamble(lineOutputStream, mimeBodyPart, string3);
                for (int j = 0; j < mimeMultipart.getCount(); ++j) {
                    lineOutputStream.writeln(string3);
                    BodyPart bodyPart2 = mimeMultipart.getBodyPart(j);
                    SMIMEUtil.outputBodyPart(outputStream, bodyPart2, string2);
                    if (!(bodyPart2.getContent() instanceof MimeMultipart)) {
                        lineOutputStream.writeln();
                        continue;
                    }
                    SMIMEUtil.outputPostamble(lineOutputStream, (BodyPart)mimeBodyPart, string3, bodyPart2);
                }
                lineOutputStream.writeln(string3 + "--");
                SMIMEUtil.outputPostamble(lineOutputStream, mimeBodyPart, mimeMultipart.getCount(), string3);
                return;
            }
            String string5 = stringArray == null ? string2 : stringArray[0];
            if (!string5.equalsIgnoreCase("base64") && !string5.equalsIgnoreCase("quoted-printable")) {
                if (!string5.equalsIgnoreCase("binary")) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                bodyPart.writeTo(outputStream);
                outputStream.flush();
                return;
            }
            boolean bl = string5.equalsIgnoreCase("base64");
            try {
                inputStream = mimeBodyPart.getRawInputStream();
            }
            catch (MessagingException messagingException) {
                outputStream = new CRLFOutputStream(outputStream);
                bodyPart.writeTo(outputStream);
                outputStream.flush();
                return;
            }
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            Object object2 = mimeBodyPart.getAllHeaderLines();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                lineOutputStream.writeln((String)object);
            }
            lineOutputStream.writeln();
            lineOutputStream.flush();
            object2 = bl ? new Base64CRLFOutputStream(outputStream) : new CRLFOutputStream(outputStream);
            object = new byte[32760];
            while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) > 0) {
                ((OutputStream)object2).write((byte[])object, 0, n);
            }
            ((OutputStream)object2).flush();
        } else {
            if (!string2.equalsIgnoreCase("binary")) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            bodyPart.writeTo(outputStream);
            outputStream.flush();
        }
    }

    public static MimeBodyPart toMimeBodyPart(byte[] byArray) throws SMIMEException {
        return SMIMEUtil.toMimeBodyPart(new ByteArrayInputStream(byArray));
    }

    public static MimeBodyPart toMimeBodyPart(InputStream inputStream) throws SMIMEException {
        try {
            return new MimeBodyPart(inputStream);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception creating body part.", (Exception)((Object)messagingException));
        }
    }

    static FileBackedMimeBodyPart toWriteOnceBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return new WriteOnceFileBackedMimeBodyPart(cMSTypedStream.getContentStream(), File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return SMIMEUtil.toMimeBodyPart(cMSTypedStream, File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream, File file2) throws SMIMEException {
        try {
            return new FileBackedMimeBodyPart(cMSTypedStream.getContentStream(), file2);
        }
        catch (IOException iOException) {
            throw new SMIMEException("can't save content to file: " + iOException, iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    public static IssuerAndSerialNumber createIssuerAndSerialNumberFor(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            return new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal(x509Certificate), x509Certificate.getSerialNumber());
        }
        catch (Exception exception2) {
            throw new CertificateParsingException("exception extracting issuer and serial number: " + exception2);
        }
    }

    static class Base64CRLFOutputStream
    extends FilterOutputStream {
        protected int lastb = -1;
        protected static byte[] newline = new byte[2];
        private boolean isCrlfStream;

        public Base64CRLFOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            if (n == 13) {
                this.out.write(newline);
            } else if (n == 10) {
                if (this.lastb != 13) {
                    if (!this.isCrlfStream || this.lastb != 10) {
                        this.out.write(newline);
                    }
                } else {
                    this.isCrlfStream = true;
                }
            } else {
                this.out.write(n);
            }
            this.lastb = n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int j = n; j != n + n2; ++j) {
                this.write(byArray[j]);
            }
        }

        public void writeln() throws IOException {
            this.out.write(newline);
        }

        static {
            Base64CRLFOutputStream.newline[0] = 13;
            Base64CRLFOutputStream.newline[1] = 10;
        }
    }

    static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string2) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string2);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception2) {
                throw new MessagingException("IOException", exception2);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception2) {
                throw new MessagingException("IOException", exception2);
            }
        }

        private static byte[] getBytes(String string2) {
            char[] cArray = string2.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }

    private static class WriteOnceFileBackedMimeBodyPart
    extends FileBackedMimeBodyPart {
        public WriteOnceFileBackedMimeBodyPart(InputStream inputStream, File file2) throws MessagingException, IOException {
            super(inputStream, file2);
        }

        public void writeTo(OutputStream outputStream) throws MessagingException, IOException {
            super.writeTo(outputStream);
            this.dispose();
        }
    }
}

