/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.openssl;

import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.crypto.PBEParametersGenerator;
import org.jruby.org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.jruby.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.jruby.org.bouncycastle.crypto.params.KeyParameter;
import org.jruby.org.bouncycastle.openssl.EncryptionException;

final class PEMUtilities {
    private static final Map KEYSIZES = new HashMap();
    private static final Set PKCS5_SCHEME_1 = new HashSet();
    private static final Set PKCS5_SCHEME_2 = new HashSet();

    PEMUtilities() {
    }

    static int getKeySize(String string2) {
        if (!KEYSIZES.containsKey(string2)) {
            throw new IllegalStateException("no key size for algorithm: " + string2);
        }
        return (Integer)KEYSIZES.get(string2);
    }

    static boolean isPKCS5Scheme1(DERObjectIdentifier dERObjectIdentifier) {
        return PKCS5_SCHEME_1.contains(dERObjectIdentifier);
    }

    static boolean isPKCS5Scheme2(DERObjectIdentifier dERObjectIdentifier) {
        return PKCS5_SCHEME_2.contains(dERObjectIdentifier);
    }

    static boolean isPKCS12(DERObjectIdentifier dERObjectIdentifier) {
        return dERObjectIdentifier.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    static SecretKey generateSecretKeyForPKCS5Scheme2(String string2, char[] cArray, byte[] byArray, int n) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, n);
        return new SecretKeySpec(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(PEMUtilities.getKeySize(string2))).getKey(), string2);
    }

    static byte[] crypt(boolean bl, String string2, byte[] byArray, char[] cArray, String string3, byte[] byArray2) throws IOException {
        Provider provider = null;
        if (string2 != null && (provider = Security.getProvider(string2)) == null) {
            throw new EncryptionException("cannot find provider: " + string2);
        }
        return PEMUtilities.crypt(bl, provider, byArray, cArray, string3, byArray2);
    }

    static byte[] crypt(boolean bl, Provider provider, byte[] byArray, char[] cArray, String string2, byte[] byArray2) throws IOException {
        SecretKey secretKey;
        String string3;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string4 = "CBC";
        String string5 = "PKCS5Padding";
        if (string2.endsWith("-CFB")) {
            string4 = "CFB";
            string5 = "NoPadding";
        }
        if (string2.endsWith("-ECB") || "DES-EDE".equals(string2) || "DES-EDE3".equals(string2)) {
            string4 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string2.endsWith("-OFB")) {
            string4 = "OFB";
            string5 = "NoPadding";
        }
        if (string2.startsWith("DES-EDE")) {
            string3 = "DESede";
            boolean bl2 = !string2.startsWith("DES-EDE3");
            secretKey = PEMUtilities.getKey(cArray, string3, 24, byArray2, bl2);
        } else if (string2.startsWith("DES-")) {
            string3 = "DES";
            secretKey = PEMUtilities.getKey(cArray, string3, 8, byArray2);
        } else if (string2.startsWith("BF-")) {
            string3 = "Blowfish";
            secretKey = PEMUtilities.getKey(cArray, string3, 16, byArray2);
        } else if (string2.startsWith("RC2-")) {
            string3 = "RC2";
            int n = 128;
            if (string2.startsWith("RC2-40-")) {
                n = 40;
            } else if (string2.startsWith("RC2-64-")) {
                n = 64;
            }
            secretKey = PEMUtilities.getKey(cArray, string3, n / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n) : new RC2ParameterSpec(n, byArray2);
        } else if (string2.startsWith("AES-")) {
            int n;
            string3 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string2.startsWith("AES-128-")) {
                n = 128;
            } else if (string2.startsWith("AES-192-")) {
                n = 192;
            } else if (string2.startsWith("AES-256-")) {
                n = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = PEMUtilities.getKey(cArray, "AES", n / 8, byArray3);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string6 = string3 + "/" + string4 + "/" + string5;
        try {
            int n;
            Cipher cipher2 = Cipher.getInstance(string6, provider);
            int n2 = n = bl ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher2.init(n, secretKey);
            } else {
                cipher2.init(n, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher2.doFinal(byArray);
        }
        catch (Exception exception2) {
            throw new EncryptionException("exception using cipher - please check password and data.", exception2);
        }
    }

    private static SecretKey getKey(char[] cArray, String string2, int n, byte[] byArray) {
        return PEMUtilities.getKey(cArray, string2, n, byArray, false);
    }

    private static SecretKey getKey(char[] cArray, String string2, int n, byte[] byArray, boolean bl) {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        KeyParameter keyParameter = (KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8);
        byte[] byArray2 = keyParameter.getKey();
        if (bl && byArray2.length >= 24) {
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
        }
        return new SecretKeySpec(byArray2, string2);
    }

    static {
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.id_PBES2);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes128_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes192_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes256_CBC);
        KEYSIZES.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), new Integer(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), new Integer(128));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), new Integer(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), new Integer(256));
    }
}

