/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import org.apache.commons.lang.Validate;

public class SwiftBlock2Output
extends SwiftBlock2
implements Serializable {
    private String senderInputTime;
    private String MIRDate;
    private String MIRLogicalTerminal;
    private String MIRSessionNumber;
    private String MIRSequenceNumber;
    private String receiverOutputDate;
    private String receiverOutputTime;

    public SwiftBlock2Output(String messageType, String senderInputTime, String MIRDate, String MIRLogicalTerminal, String MIRSessionNumber, String MIRSequenceNumber, String receiverOutputDate, String receiverOutputTime, String messagePriority) {
        this.messageType = messageType;
        this.senderInputTime = senderInputTime;
        this.MIRDate = MIRDate;
        this.MIRLogicalTerminal = MIRLogicalTerminal;
        this.MIRSessionNumber = MIRSessionNumber;
        this.MIRSequenceNumber = MIRSequenceNumber;
        this.receiverOutputDate = receiverOutputDate;
        this.receiverOutputTime = receiverOutputTime;
        this.messagePriority = messagePriority;
    }

    public SwiftBlock2Output(String value) {
        this.setValue(value);
    }

    public SwiftBlock2Output() {
    }

    public void setSenderInputTime(String senderInputTime) {
        this.senderInputTime = senderInputTime;
    }

    public String getSenderInputTime() {
        return this.senderInputTime;
    }

    public void setMIRDate(String MIRDate) {
        this.MIRDate = MIRDate;
    }

    public String getMIRDate() {
        return this.MIRDate;
    }

    public void setMIRLogicalTerminal(String MIRLogicalTerminal) {
        this.MIRLogicalTerminal = MIRLogicalTerminal;
    }

    public String getMIRLogicalTerminal() {
        return this.MIRLogicalTerminal;
    }

    public void setMIRSessionNumber(String MIRSessionNumber) {
        this.MIRSessionNumber = MIRSessionNumber;
    }

    public String getMIRSessionNumber() {
        return this.MIRSessionNumber;
    }

    public void setMIRSequenceNumber(String MIRSequenceNumber) {
        this.MIRSequenceNumber = MIRSequenceNumber;
    }

    public String getMIRSequenceNumber() {
        return this.MIRSequenceNumber;
    }

    public String getMIR() {
        if (this.MIRDate == null && this.MIRLogicalTerminal == null && this.MIRSessionNumber == null && this.MIRSequenceNumber == null) {
            return null;
        }
        StringBuffer v = new StringBuffer();
        if (this.MIRDate != null) {
            v.append(this.MIRDate);
        }
        if (this.MIRLogicalTerminal != null) {
            v.append(this.MIRLogicalTerminal);
        }
        if (this.MIRSessionNumber != null) {
            v.append(this.MIRSessionNumber);
        }
        if (this.MIRSequenceNumber != null) {
            v.append(this.MIRSequenceNumber);
        }
        return v.toString();
    }

    public void setMIR(String mir) {
        Validate.notNull((Object)mir);
        Validate.isTrue((mir.length() == 28 ? 1 : 0) != 0, (String)("expected a 28 characters string for MIR value and found a " + mir.length() + " string:" + mir));
        StringBuffer sb = new StringBuffer(mir);
        int offset = 0;
        int len = 6;
        this.setMIRDate(String.valueOf(sb.subSequence(offset, offset + len)));
        offset += len;
        len = 12;
        this.setMIRLogicalTerminal(String.valueOf(sb.subSequence(offset, offset + len)));
        offset += len;
        len = 4;
        this.setMIRSessionNumber(String.valueOf(sb.subSequence(offset, offset + len)));
        offset += len;
        len = 6;
        this.setMIRSequenceNumber(String.valueOf(sb.subSequence(offset, offset + len)));
        offset += len;
    }

    public void setReceiverOutputDate(String receiverOutputDate) {
        this.receiverOutputDate = receiverOutputDate;
    }

    public String getReceiverOutputDate() {
        return this.receiverOutputDate;
    }

    public void setReceiverOutputTime(String receiverOutputTime) {
        this.receiverOutputTime = receiverOutputTime;
    }

    public String getReceiverOutputTime() {
        return this.receiverOutputTime;
    }

    public boolean isEmpty() {
        return this.messageType == null && this.senderInputTime == null && this.getMIR() == null && this.receiverOutputDate == null && this.receiverOutputTime == null && this.messagePriority == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer v = new StringBuffer("O");
        if (this.messageType != null) {
            v.append(this.messageType);
        }
        if (this.senderInputTime != null) {
            v.append(this.senderInputTime);
        }
        if (this.getMIR() != null) {
            v.append(this.getMIR());
        }
        if (this.receiverOutputDate != null) {
            v.append(this.receiverOutputDate);
        }
        if (this.receiverOutputTime != null) {
            v.append(this.receiverOutputTime);
        }
        if (this.messagePriority != null) {
            v.append(this.messagePriority);
        }
        return v.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        int slen = value.length();
        Validate.notNull((Object)value, (String)"value must not be null");
        Validate.isTrue((slen == 46 || slen == 48 || slen == 47 || slen == 49 ? 1 : 0) != 0, (String)("expected a string value of 46 and up to 49 chars and obtained a " + slen + " chars string: '" + value + "'"));
        int offset = 0;
        if (value.startsWith("2:O")) {
            offset = 2;
        }
        if ((slen -= offset) != 46 && slen != 47) {
            throw new IllegalArgumentException("Value must match: O<mt><time><mir><date><time>[<pri>]");
        }
        if (Character.toUpperCase(value.charAt(offset)) != 'O') {
            throw new IllegalArgumentException("Value must match: O<mt><time><mir><date><time>[<pri>]");
        }
        int len = 3;
        this.setMessageType(this.getValuePart(value, ++offset, len));
        offset += len;
        len = 4;
        this.setSenderInputTime(this.getValuePart(value, offset, len));
        offset += len;
        len = 28;
        this.setMIR(this.getValuePart(value, offset, len));
        offset += len;
        len = 6;
        this.setReceiverOutputDate(this.getValuePart(value, offset, len));
        offset += len;
        len = 4;
        this.setReceiverOutputTime(this.getValuePart(value, offset, len));
        offset += len;
        len = 1;
        this.setMessagePriority(this.getValuePart(value, offset, len));
        offset += len;
    }

    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public boolean isInput() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.MIRDate == null ? 0 : this.MIRDate.hashCode());
        result = 31 * result + (this.MIRLogicalTerminal == null ? 0 : this.MIRLogicalTerminal.hashCode());
        result = 31 * result + (this.MIRSequenceNumber == null ? 0 : this.MIRSequenceNumber.hashCode());
        result = 31 * result + (this.MIRSessionNumber == null ? 0 : this.MIRSessionNumber.hashCode());
        result = 31 * result + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = 31 * result + (this.receiverOutputDate == null ? 0 : this.receiverOutputDate.hashCode());
        result = 31 * result + (this.receiverOutputTime == null ? 0 : this.receiverOutputTime.hashCode());
        result = 31 * result + (this.senderInputTime == null ? 0 : this.senderInputTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock2Output other = (SwiftBlock2Output)obj;
        if (this.MIRDate == null ? other.MIRDate != null : !this.MIRDate.equals(other.MIRDate)) {
            return false;
        }
        if (this.MIRLogicalTerminal == null ? other.MIRLogicalTerminal != null : !this.MIRLogicalTerminal.equals(other.MIRLogicalTerminal)) {
            return false;
        }
        if (this.MIRSequenceNumber == null ? other.MIRSequenceNumber != null : !this.MIRSequenceNumber.equals(other.MIRSequenceNumber)) {
            return false;
        }
        if (this.MIRSessionNumber == null ? other.MIRSessionNumber != null : !this.MIRSessionNumber.equals(other.MIRSessionNumber)) {
            return false;
        }
        if (this.messagePriority == null ? other.messagePriority != null : !this.messagePriority.equals(other.messagePriority)) {
            return false;
        }
        if (this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType)) {
            return false;
        }
        if (this.receiverOutputDate == null ? other.receiverOutputDate != null : !this.receiverOutputDate.equals(other.receiverOutputDate)) {
            return false;
        }
        if (this.receiverOutputTime == null ? other.receiverOutputTime != null : !this.receiverOutputTime.equals(other.receiverOutputTime)) {
            return false;
        }
        return !(this.senderInputTime == null ? other.senderInputTime != null : !this.senderInputTime.equals(other.senderInputTime));
    }
}

