/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.UserMetadata;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASS
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)PASS.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        boolean success = false;
        FtpServerContext serverContext = connection.getServerContext();
        ConnectionManager conManager = serverContext.getConnectionManager();
        ServerFtpStatistics stat = (ServerFtpStatistics)serverContext.getFtpStatistics();
        try {
            session.resetState();
            String password = request.getArgument();
            if (password == null) {
                out.write(FtpReplyUtil.translate(session, 501, "PASS", null));
                return;
            }
            String userName = session.getUserArgument();
            if (userName == null && session.getUser() == null) {
                out.write(FtpReplyUtil.translate(session, 503, "PASS", null));
                return;
            }
            if (session.isLoggedIn()) {
                out.write(FtpReplyUtil.translate(session, 202, "PASS", null));
                success = true;
                return;
            }
            boolean anonymous = userName.equals("anonymous");
            int currAnonLogin = stat.getCurrentAnonymousLoginNumber();
            int maxAnonLogin = conManager.getMaxAnonymousLogins();
            if (anonymous && currAnonLogin >= maxAnonLogin) {
                out.write(FtpReplyUtil.translate(session, 421, "PASS.anonymous", null));
                return;
            }
            int currLogin = stat.getCurrentLoginNumber();
            int maxLogin = conManager.getMaxLogins();
            if (maxLogin != 0 && currLogin >= maxLogin) {
                out.write(FtpReplyUtil.translate(session, 421, "PASS.login", null));
                return;
            }
            UserManager userManager = serverContext.getUserManager();
            User authenticatedUser = null;
            try {
                UserMetadata userMetadata = new UserMetadata();
                userMetadata.setInetAddress(session.getClientAddress());
                userMetadata.setCertificateChain(session.getClientCertificates());
                Object auth = anonymous ? new AnonymousAuthentication(userMetadata) : new UsernamePasswordAuthentication(userName, password, userMetadata);
                authenticatedUser = userManager.authenticate((Authentication)auth);
                success = true;
            }
            catch (AuthenticationFailedException e) {
                success = false;
                authenticatedUser = null;
                this.LOG.warn("User failed to log in", (Throwable)e);
            }
            catch (Exception e) {
                success = false;
                authenticatedUser = null;
                this.LOG.warn("PASS.execute()", (Throwable)e);
            }
            User oldUser = session.getUser();
            String oldUserArgument = session.getUserArgument();
            int oldMaxIdleTime = session.getMaxIdleTime();
            if (success) {
                session.setUser(authenticatedUser);
                session.setUserArgument(null);
                session.setMaxIdleTime(authenticatedUser.getMaxIdleTime());
            } else {
                session.setUser(null);
            }
            Ftplet ftpletContainer = serverContext.getFtpletContainer();
            if (ftpletContainer != null) {
                FtpletEnum ftpletRet;
                try {
                    ftpletRet = ftpletContainer.onLogin((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    success = false;
                }
            }
            if (!success) {
                session.setUser(oldUser);
                session.setUserArgument(oldUserArgument);
                session.setMaxIdleTime(oldMaxIdleTime);
                this.LOG.warn("Login failure - " + userName);
                out.write(FtpReplyUtil.translate(session, 530, "PASS", userName));
                stat.setLoginFail(connection);
                return;
            }
            FileSystemManager fmanager = serverContext.getFileSystemManager();
            FileSystemView fsview = fmanager.createFileSystemView(authenticatedUser);
            session.setLogin(fsview);
            stat.setLogin(connection);
            out.write(FtpReplyUtil.translate(session, 230, "PASS", userName));
            if (anonymous) {
                this.LOG.info("Anonymous login success - " + password);
            } else {
                this.LOG.info("Login success - " + userName);
            }
        }
        finally {
            if (!success) {
                session.reinitialize();
            }
        }
    }
}

